/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInitializerTypeMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirInitializerTypeMismatchChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInitializerTypeMismatchChecker INSTANCE = new FirInitializerTypeMismatchChecker();

    private FirInitializerTypeMismatchChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression firExpression2 = declaration2.getInitializer();
        if (firExpression2 == null) {
            return;
        }
        FirExpression initializer2 = firExpression2;
        FirSourceElement firSourceElement = declaration2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            return;
        }
        if (FirHelpersKt.isComponentCall(initializer2)) {
            return;
        }
        firSourceElement = declaration2.getReturnTypeRef().getSource();
        if (!Intrinsics.areEqual((Object)(firSourceElement == null ? null : firSourceElement.getKind()), (Object)FirRealSourceElementKind.INSTANCE)) {
            return;
        }
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef());
        FirTypeRef $this$coneTypeSafe$iv = initializer2.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            return;
        }
        ConeKotlinType expressionType = coneKotlinType;
        ConeInferenceContext typeContext2 = SessionUtilsKt.getTypeContext(context2.getSession());
        if (!FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, expressionType, propertyType)) {
            if (expressionType instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)expressionType).getLookupTag().getClassId(), (Object)StandardClassIds.INSTANCE.getInt()) && ConeTypeUtilsKt.isIntegerTypeOrNullableIntegerTypeOfAnySize(TypeExpansionUtilsKt.fullyExpandedType(propertyType, context2.getSession())) && expressionType.getNullability() == ConeNullability.NOT_NULL) {
                return;
            }
            if (CompilerConeAttributesKt.isExtensionFunctionType(propertyType) || CompilerConeAttributesKt.isExtensionFunctionType(expressionType)) {
                return;
            }
            if (FirTypeUtilsKt.isNullLiteral(initializer2) && propertyType.getNullability() == ConeNullability.NOT_NULL) {
                DiagnosticReporterKt.reportOn(reporter, initializer2.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), context2);
            } else {
                reporter.report((FirDiagnostic)FirErrors.INSTANCE.getINITIALIZER_TYPE_MISMATCH().on(source, propertyType, expressionType), context2);
            }
        }
    }
}

