/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Buildable;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationArtifact;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.plugins.signing.Signature;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public class Sign
extends DefaultTask
implements SignatureSpec {
    private SignatureType signatureType;
    private Signatory signatory;
    private boolean required = true;
    private final DomainObjectSet<Signature> signatures = this.getProject().getObjects().domainObjectSet(Signature.class);

    @Inject
    public Sign() {
        this.onlyIf(task -> this.isRequired() || this.getSignatory() != null);
    }

    public void sign(Task ... tasks) {
        for (Task task : tasks) {
            if (!(task instanceof AbstractArchiveTask)) {
                throw new InvalidUserDataException("You cannot sign tasks that are not 'archive' tasks, such as 'jar', 'zip' etc. (you tried to sign " + task + ")");
            }
            this.signTask((AbstractArchiveTask)task);
        }
    }

    private void signTask(AbstractArchiveTask archiveTask) {
        this.dependsOn(new Object[]{archiveTask});
        this.addSignature(new Signature(() -> ((RegularFile)archiveTask.getArchiveFile().get()).getAsFile(), () -> (String)archiveTask.getArchiveClassifier().getOrNull(), (SignatureSpec)this, this));
    }

    public void sign(PublishArtifact ... publishArtifacts) {
        for (PublishArtifact publishArtifact : publishArtifacts) {
            this.signArtifact(publishArtifact);
        }
    }

    private void signArtifact(PublishArtifact publishArtifact) {
        this.dependsOn(new Object[]{publishArtifact});
        this.addSignature(new Signature(publishArtifact, (SignatureSpec)this, this));
    }

    public void sign(File ... files) {
        this.addSignatures(null, files);
    }

    public void sign(String classifier, File ... files) {
        this.addSignatures(classifier, files);
    }

    private void addSignatures(String classifier, File[] files) {
        for (File file : files) {
            this.addSignature(new Signature(file, classifier, (SignatureSpec)this, this));
        }
    }

    public void sign(Configuration ... configurations) {
        for (Configuration configuration : configurations) {
            configuration.getAllArtifacts().all(artifact -> {
                if (artifact instanceof Signature || this.hasSignatureFor((Buildable)artifact)) {
                    return;
                }
                this.signArtifact((PublishArtifact)artifact);
            });
            configuration.getAllArtifacts().whenObjectRemoved(this::removeSignature);
        }
    }

    private boolean hasSignatureFor(Buildable source) {
        return this.signatures.stream().anyMatch(this.hasSource(source));
    }

    public void sign(Publication ... publications) {
        for (Publication publication : publications) {
            PublicationInternal publicationInternal = (PublicationInternal)publication;
            this.dependsOn(new Object[]{() -> publicationInternal.getPublishableArtifacts().matching(this::isNoSignatureArtifact)});
            publicationInternal.allPublishableArtifacts(artifact -> {
                if (this.isNoSignatureArtifact((PublicationArtifact)artifact)) {
                    this.addSignature(new Signature((Buildable)artifact, () -> ((PublicationArtifact)artifact).getFile(), null, null, this, this));
                }
            });
            publicationInternal.whenPublishableArtifactRemoved(this::removeSignature);
        }
    }

    private boolean isNoSignatureArtifact(PublicationArtifact artifact) {
        return !this.getSignatureFiles().contains(artifact.getFile());
    }

    private void addSignature(Signature signature) {
        this.signatures.add((Object)signature);
    }

    private void removeSignature(Buildable source) {
        this.signatures.removeIf(this.hasSource(source));
    }

    private Predicate<Signature> hasSource(Buildable source) {
        return signature -> signature.getSource().equals(source);
    }

    public void signatory(Signatory signatory) {
        this.signatory = signatory;
    }

    public void required(boolean required) {
        this.setRequired(required);
    }

    @TaskAction
    public void generate() {
        if (this.getSignatory() == null) {
            throw new InvalidUserDataException("Cannot perform signing task '" + this.getPath() + "' because it has no configured signatory");
        }
        for (Signature signature : this.sanitizedSignatures().values()) {
            signature.generate();
        }
    }

    @Internal
    public DomainObjectSet<Signature> getSignatures() {
        return this.signatures;
    }

    @Nested
    public Map<String, Signature> getSignaturesByKey() {
        return this.sanitizedSignatures();
    }

    private Map<String, Signature> sanitizedSignatures() {
        return this.signatures.matching(signature -> signature.getToSign().exists()).stream().collect(Collectors.toMap(Signature::toKey, Function.identity(), (signature, duplicate) -> signature));
    }

    @Internal
    public Signature getSingleSignature() {
        Map<String, Signature> sanitizedSignatures = this.sanitizedSignatures();
        if (sanitizedSignatures.size() == 1) {
            return sanitizedSignatures.values().iterator().next();
        }
        throw new IllegalStateException("Expected %s to contain exactly one signature, however, it contains " + sanitizedSignatures.size() + " signatures.");
    }

    @Inject
    protected FileCollectionFactory getFileCollectionFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public FileCollection getFilesToSign() {
        return this.getFileCollectionFactory().fixed("Task '" + this.getPath() + "' files to sign", (Collection)Lists.newLinkedList((Iterable)Iterables.filter((Iterable)Iterables.transform(this.signatures, Signature::getToSign), (com.google.common.base.Predicate)Predicates.notNull())));
    }

    @Internal
    public FileCollection getSignatureFiles() {
        return this.getFileCollectionFactory().fixed("Task '" + this.getPath() + "' signature files", (Collection)Lists.newLinkedList((Iterable)Iterables.filter((Iterable)Iterables.transform(this.signatures, Signature::getFile), (com.google.common.base.Predicate)Predicates.notNull())));
    }

    @Override
    @Nested
    @Optional
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Override
    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    @Override
    @Nested
    @Optional
    public Signatory getSignatory() {
        return this.signatory;
    }

    @Override
    public void setSignatory(Signatory signatory) {
        this.signatory = signatory;
    }

    @Override
    @Input
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Inject
    protected CollectionCallbackActionDecorator getCallbackActionDecorator() {
        throw new UnsupportedOperationException();
    }
}

