/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.Optional;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.cache.Cache;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredExecutionHandler;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.impl.DefaultWorkValidationContext;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private final DocumentationRegistry documentationRegistry;
    private final DeferredExecutionAwareStep<? super ExecutionRequestContext, ? extends ExecutionEngine.Result> executeStep;

    public DefaultExecutionEngine(DocumentationRegistry documentationRegistry, DeferredExecutionAwareStep<? super ExecutionRequestContext, ? extends ExecutionEngine.Result> executeStep) {
        this.documentationRegistry = documentationRegistry;
        this.executeStep = executeStep;
    }

    @Override
    public ExecutionEngine.Request createRequest(final UnitOfWork work) {
        return new ExecutionEngine.Request(){
            private String rebuildReason;
            private WorkValidationContext validationContext;

            private ExecutionRequestContext createExecutionRequestContext() {
                final WorkValidationContext validationContext = this.validationContext != null ? this.validationContext : new DefaultWorkValidationContext(DefaultExecutionEngine.this.documentationRegistry, work.getTypeOriginInspector());
                return new ExecutionRequestContext(){

                    @Override
                    public Optional<String> getRebuildReason() {
                        return Optional.ofNullable(rebuildReason);
                    }

                    @Override
                    public WorkValidationContext getValidationContext() {
                        return validationContext;
                    }
                };
            }

            @Override
            public void forceRebuild(String rebuildReason) {
                this.rebuildReason = rebuildReason;
            }

            @Override
            public void withValidationContext(WorkValidationContext validationContext) {
                this.validationContext = validationContext;
            }

            @Override
            public ExecutionEngine.Result execute() {
                return (ExecutionEngine.Result)DefaultExecutionEngine.this.executeStep.execute(work, this.createExecutionRequestContext());
            }

            @Override
            public <O> ExecutionEngine.CachedRequest<O> withIdentityCache(final Cache<UnitOfWork.Identity, Try<O>> cache) {
                return new ExecutionEngine.CachedRequest<O>(){

                    @Override
                    public <T> T getOrDeferExecution(DeferredExecutionHandler<O, T> handler) {
                        return DefaultExecutionEngine.this.executeStep.executeDeferred(work, this.createExecutionRequestContext(), cache, handler);
                    }
                };
            }
        };
    }
}

