/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.Pair;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class InstrumentingBackwardsCompatibilityVisitor
extends ClassVisitor {
    private static final List<Pair<String, String>> RENAMED_TYPE_INTERNAL_NAMES = Arrays.asList(Pair.of((Object)"org/gradle/logging/LoggingManagerInternal", (Object)"org/gradle/api/logging/LoggingManager"), Pair.of((Object)"org/gradle/logging/StandardOutputCapture", (Object)"org/gradle/internal/logging/StandardOutputCapture"));
    private static final List<Pair<String, String>> RENAMED_TYPE_DESCRIPTORS = RENAMED_TYPE_INTERNAL_NAMES.stream().map(p -> Pair.of((Object)("L" + (String)p.left + ";"), (Object)("L" + (String)p.right + ";"))).collect(Collectors.toList());

    InstrumentingBackwardsCompatibilityVisitor(ClassVisitor classVisitor) {
        super(524288, classVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String newSuperName = InstrumentingBackwardsCompatibilityVisitor.fixInternalNameForBackwardCompatibility(superName);
        String[] newInterfaces = InstrumentingBackwardsCompatibilityVisitor.fixInternalNamesForBackwardsCompatibility(interfaces);
        super.visit(version, access, name, signature, newSuperName, newInterfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
        return super.visitField(access, name, newDescriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
        MethodVisitor methodVisitor = super.visitMethod(access, name, newDescriptor, signature, exceptions);
        return methodVisitor != null ? new BackwardCompatibilityMethodVisitor(methodVisitor) : null;
    }

    private static Object[] fixAsmObjectsForBackwardsCompatibility(Object[] values) {
        Object[] newValues = new Object[values.length];
        for (int idx = 0; idx < values.length; ++idx) {
            newValues[idx] = InstrumentingBackwardsCompatibilityVisitor.fixAsmObjectForBackwardsCompatibility(values[idx]);
        }
        return newValues;
    }

    private static Object fixAsmObjectForBackwardsCompatibility(Object value) {
        if (value instanceof Type) {
            Type type = (Type)value;
            String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(type.getDescriptor());
            return Type.getType((String)newDescriptor);
        }
        if (value instanceof Handle) {
            Handle handle = (Handle)value;
            return InstrumentingBackwardsCompatibilityVisitor.fixHandleForBackwardsCompatibility(handle);
        }
        return value;
    }

    private static Handle fixHandleForBackwardsCompatibility(Handle handle) {
        String newHandleOwner = InstrumentingBackwardsCompatibilityVisitor.fixInternalNameForBackwardCompatibility(handle.getOwner());
        String newHandleDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(handle.getDesc());
        return new Handle(handle.getTag(), newHandleOwner, handle.getName(), newHandleDescriptor, handle.isInterface());
    }

    private static String[] fixInternalNamesForBackwardsCompatibility(String[] internalNames) {
        String[] newInternalNames = new String[internalNames.length];
        for (int idx = 0; idx < internalNames.length; ++idx) {
            newInternalNames[idx] = InstrumentingBackwardsCompatibilityVisitor.fixInternalNameForBackwardCompatibility(internalNames[idx]);
        }
        return newInternalNames;
    }

    private static String fixInternalNameForBackwardCompatibility(String internalName) {
        for (Pair<String, String> renamedInterface : RENAMED_TYPE_INTERNAL_NAMES) {
            if (!((String)renamedInterface.left).equals(internalName)) continue;
            return (String)renamedInterface.right;
        }
        return internalName;
    }

    private static String fixDescriptorForBackwardCompatibility(String descriptor) {
        for (Pair<String, String> renamedDescriptor : RENAMED_TYPE_DESCRIPTORS) {
            descriptor = descriptor.replace((CharSequence)renamedDescriptor.left, (CharSequence)renamedDescriptor.right);
        }
        return descriptor;
    }

    private static class BackwardCompatibilityMethodVisitor
    extends MethodVisitor {
        public BackwardCompatibilityMethodVisitor(MethodVisitor methodVisitor) {
            super(524288, methodVisitor);
        }

        public void visitTypeInsn(int opcode, String type) {
            String newType = InstrumentingBackwardsCompatibilityVisitor.fixInternalNameForBackwardCompatibility(type);
            super.visitTypeInsn(opcode, newType);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            String newOwner = InstrumentingBackwardsCompatibilityVisitor.fixInternalNameForBackwardCompatibility(owner);
            String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
            super.visitFieldInsn(opcode, newOwner, name, newDescriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            String newOwner = InstrumentingBackwardsCompatibilityVisitor.fixInternalNameForBackwardCompatibility(owner);
            String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
            super.visitMethodInsn(opcode, newOwner, name, newDescriptor, isInterface);
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
            super.visitMultiANewArrayInsn(newDescriptor, numDimensions);
        }

        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
            super.visitLocalVariable(name, newDescriptor, signature, start, end, index);
        }

        public void visitLdcInsn(Object value) {
            Object newValue = InstrumentingBackwardsCompatibilityVisitor.fixAsmObjectForBackwardsCompatibility(value);
            super.visitLdcInsn(newValue);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            String newDescriptor = InstrumentingBackwardsCompatibilityVisitor.fixDescriptorForBackwardCompatibility(descriptor);
            Handle newBootstrapMethodHandle = InstrumentingBackwardsCompatibilityVisitor.fixHandleForBackwardsCompatibility(bootstrapMethodHandle);
            Object[] newBootstrapMethodArguments = InstrumentingBackwardsCompatibilityVisitor.fixAsmObjectsForBackwardsCompatibility(bootstrapMethodArguments);
            super.visitInvokeDynamicInsn(name, newDescriptor, newBootstrapMethodHandle, newBootstrapMethodArguments);
        }
    }
}

