/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.TemporaryAssignmentElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "hasChanges", "", "namesToProcess", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "referenceCount", "", "", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "syntheticNames", "usageSequences", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "usages", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "analyze", "", "apply", "calculateDeclarations", "generateDeclarations", "getUsageSequence", "name", "process", "tryRecord", "expr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "usage", "use", "Usage", "UsageSequence", "js.translator"})
public final class TemporaryAssignmentElimination {
    @NotNull
    private final JsBlock root;
    @NotNull
    private final Map<JsName, Integer> referenceCount;
    @NotNull
    private final Map<JsName, Usage> usages;
    @NotNull
    private final Set<JsStatement> statementsToRemove;
    @NotNull
    private final Map<JsName, UsageSequence> usageSequences;
    @NotNull
    private final Set<JsName> syntheticNames;
    private boolean hasChanges;
    @NotNull
    private final Set<JsName> namesToProcess;

    public TemporaryAssignmentElimination(@NotNull JsBlock root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.root = root2;
        boolean bl = false;
        this.referenceCount = new LinkedHashMap();
        bl = false;
        this.usages = new LinkedHashMap();
        bl = false;
        this.statementsToRemove = new LinkedHashSet();
        bl = false;
        this.usageSequences = new LinkedHashMap();
        bl = false;
        this.syntheticNames = new LinkedHashSet();
        bl = false;
        this.namesToProcess = new LinkedHashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.calculateDeclarations();
        this.process();
        this.generateDeclarations();
        return this.hasChanges;
    }

    private final void analyze() {
        this.namesToProcess.addAll((Collection<JsName>)CollectUtilsKt.collectDefinedNames(this.root));
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression returnExpr = x.getExpression();
                if (returnExpr != null) {
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, returnExpr, new Usage.Return(x));
                }
                super.visitReturn(x);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsName, JsExpression> variableAssignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (variableAssignment != null) {
                    Pair<JsName, JsExpression> pair = variableAssignment;
                    JsName name = (JsName)pair.component1();
                    JsExpression value2 = (JsExpression)pair.component2();
                    JsStatement jsStatement = x;
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    Usage.VariableAssignment usage = new Usage.VariableAssignment(jsStatement, name);
                    if (MetadataProperties.getSynthetic(x)) {
                        TemporaryAssignmentElimination temporaryAssignmentElimination = this.this$0;
                        Collection collection = TemporaryAssignmentElimination.access$getSyntheticNames$p(temporaryAssignmentElimination);
                        boolean bl = false;
                        collection.add(name);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, value2, usage);
                    this.accept((JsNode)value2);
                    return;
                }
                Pair<JsExpression, JsExpression> propertyMutation = JsAstUtils.decomposeAssignment(x.getExpression());
                if (propertyMutation != null) {
                    Pair<JsExpression, JsExpression> pair = propertyMutation;
                    JsExpression target = (JsExpression)pair.component1();
                    JsExpression value3 = (JsExpression)pair.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
                    if (!SideEffectUtilsKt.canHaveSideEffect(target, TemporaryAssignmentElimination.access$getNamesToProcess$p(this.this$0))) {
                        Usage.PropertyMutation usage = new Usage.PropertyMutation((JsStatement)x, target);
                        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"value");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, value3, usage);
                        this.accept((JsNode)value3);
                        return;
                    }
                }
                super.visitExpressionStatement(x);
            }

            public void visitVars(@NotNull JsVars x) {
                Object declaration2;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.getVars().size() == 1) {
                    Object object;
                    declaration2 = x.getVars().get(0);
                    JsExpression initExpression = ((JsVars.JsVar)declaration2).getInitExpression();
                    if (initExpression != null) {
                        JsStatement jsStatement = x;
                        object = ((JsVars.JsVar)declaration2).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"declaration.name");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, initExpression, new Usage.VariableDeclaration(jsStatement, (JsName)object));
                    }
                    if (MetadataProperties.getSynthetic(x)) {
                        object = this.this$0;
                        Collection collection = TemporaryAssignmentElimination.access$getSyntheticNames$p((TemporaryAssignmentElimination)object);
                        JsName jsName = ((JsVars.JsVar)declaration2).getName();
                        boolean bl = false;
                        collection.add(jsName);
                    }
                }
                declaration2 = x.getVars();
                Intrinsics.checkNotNullExpressionValue(declaration2, (String)"x.vars");
                Iterable $this$forEach$iv = (Iterable)declaration2;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    JsExpression jsExpression;
                    JsVars.JsVar v = (JsVars.JsVar)element$iv;
                    boolean bl = false;
                    JsVars.JsVar jsVar = v;
                    if (jsVar == null || (jsExpression = jsVar.getInitExpression()) == null) continue;
                    JsExpression jsExpression2 = jsExpression;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    JsExpression it = jsExpression2;
                    boolean bl4 = false;
                    this.accept((JsNode)it);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    TemporaryAssignmentElimination.access$use(this.this$0, name);
                    return;
                }
                super.visitNameRef(nameRef);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                TemporaryAssignmentElimination temporaryAssignmentElimination = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsName it = (JsName)element$iv;
                    boolean bl = false;
                    TemporaryAssignmentElimination.access$use(temporaryAssignmentElimination, it);
                    TemporaryAssignmentElimination.access$use(temporaryAssignmentElimination, it);
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitFor(@NotNull JsFor x) {
                JsVars it;
                boolean bl;
                boolean bl2;
                JsVars jsVars;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNode jsNode = x.getInitVars();
                if (jsNode != null) {
                    jsVars = jsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl3 = false;
                    List<JsVars.JsVar> list2 = it.getVars();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"it.vars");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        JsVars.JsVar it2 = (JsVars.JsVar)element$iv;
                        boolean bl4 = false;
                        JsExpression jsExpression = it2.getInitExpression();
                        if (jsExpression == null) continue;
                        JsExpression jsExpression2 = jsExpression;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        JsExpression it3 = jsExpression2;
                        boolean bl7 = false;
                        this.accept((JsNode)it3);
                    }
                }
                jsNode = x.getInitExpression();
                if (jsNode != null) {
                    jsVars = jsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl8 = false;
                    this.accept((JsNode)it);
                }
                jsNode = x.getCondition();
                if (jsNode != null) {
                    jsVars = jsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl9 = false;
                    this.accept((JsNode)it);
                }
                jsNode = x.getBody();
                if (jsNode != null) {
                    jsVars = jsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl10 = false;
                    this.accept((JsNode)it);
                }
                jsNode = x.getIncrementExpression();
                if (jsNode != null) {
                    jsVars = jsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl11 = false;
                    this.accept((JsNode)it);
                }
            }
        }.accept((JsNode)this.root);
        this.usages.keySet().retainAll((Collection)this.syntheticNames);
    }

    private final UsageSequence getUsageSequence(JsName name) {
        UsageSequence usageSequence;
        Map<JsName, UsageSequence> $this$getOrPut$iv = this.usageSequences;
        boolean $i$f$getOrPut = false;
        UsageSequence value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            UsageSequence mappedUsage;
            boolean bl = false;
            Integer n = this.referenceCount.get(name);
            int n2 = 1;
            if (n == null || n != n2) {
                return null;
            }
            Usage usage = this.usages.get(name);
            Usage usage2 = usage;
            UsageSequence answer$iv = mappedUsage = usage2 instanceof Usage.VariableAssignment ? new UsageSequence(usage, this.getUsageSequence(((Usage.VariableAssignment)usage).getTarget())) : (usage2 instanceof Usage.VariableDeclaration ? new UsageSequence(usage, this.getUsageSequence(((Usage.VariableDeclaration)usage).getTarget())) : (usage2 == null ? null : new UsageSequence(usage, null)));
            $this$getOrPut$iv.put(name, answer$iv);
            usageSequence = answer$iv;
        } else {
            usageSequence = value$iv;
        }
        return usageSequence;
    }

    private final void calculateDeclarations() {
        Iterable $this$forEach$iv = this.usages.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            this.getUsageSequence(it);
        }
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    Usage usage;
                    Object object = assignment.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assignment.first");
                    Object object2 = TemporaryAssignmentElimination.access$getUsageSequence(this.this$0, (JsName)object);
                    Usage usage2 = usage = object2 == null ? null : ((UsageSequence)object2).lastUsage();
                    if (usage instanceof Usage.VariableDeclaration) {
                        object2 = (Usage.VariableDeclaration)usage;
                        int n = ((Usage.VariableDeclaration)object2).getCount();
                        ((Usage.VariableDeclaration)object2).setCount(n + 1);
                    }
                }
                super.visitExpressionStatement(x);
            }
        }.accept((JsNode)this.root);
    }

    private final void process() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx2) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx2.removeMe();
                    return false;
                }
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName name = (JsName)pair.component1();
                    JsExpression value2 = (JsExpression)pair.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    UsageSequence usageSequence = TemporaryAssignmentElimination.access$getUsageSequence(this.this$0, name);
                    if (usageSequence != null) {
                        JsStatement jsStatement;
                        boolean bl;
                        Object object;
                        Usage usage = usageSequence.lastUsage();
                        Object object2 = usage;
                        if (object2 instanceof Usage.Return) {
                            object = new JsReturn(value2);
                            boolean bl2 = false;
                            bl = false;
                            JsReturn $this$visit_u24lambda_u2d0 = object;
                            boolean bl3 = false;
                            $this$visit_u24lambda_u2d0.source(x.getExpression().getSource());
                            jsStatement = (JsStatement)object;
                        } else if (object2 instanceof Usage.VariableAssignment) {
                            JsExpression expr = JsAstUtils.assignment(((Usage.VariableAssignment)usage).getTarget().makeRef(), value2).source(x.getExpression().getSource());
                            JsExpressionStatement statement2 = new JsExpressionStatement(expr);
                            MetadataProperties.setSynthetic(statement2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableAssignment)usage).getTarget()));
                            jsStatement = statement2;
                        } else if (object2 instanceof Usage.VariableDeclaration) {
                            JsStatement statement3;
                            JsStatement jsStatement2;
                            if (((Usage.VariableDeclaration)usage).getCount() > 1) {
                                JsExpression expr = JsAstUtils.assignment(((Usage.VariableDeclaration)usage).getTarget().makeRef(), value2).source(x.getExpression().getSource());
                                JsExpressionStatement result2 = new JsExpressionStatement(expr);
                                MetadataProperties.setSynthetic(result2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = result2;
                            } else {
                                JsVars jsVars = JsAstUtils.newVar(((Usage.VariableDeclaration)usage).getTarget(), value2);
                                Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"newVar(usage.target, value)");
                                JsVars declaration2 = jsVars;
                                declaration2.source(x.getExpression().getSource());
                                MetadataProperties.setSynthetic(declaration2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = declaration2;
                            }
                            jsStatement = statement3 = jsStatement2;
                        } else if (object2 instanceof Usage.PropertyMutation) {
                            jsStatement = new JsExpressionStatement(JsAstUtils.assignment(((Usage.PropertyMutation)usage).getTarget(), value2).source(x.getExpression().getSource()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        JsStatement replacement = jsStatement;
                        TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                        ctx2.replaceMe((JsNode)replacement);
                        object2 = this.this$0;
                        object = TemporaryAssignmentElimination.access$getStatementsToRemove$p((TemporaryAssignmentElimination)object2);
                        Sequence<JsStatement> sequence2 = usageSequence.collectStatements();
                        bl = false;
                        CollectionsKt.addAll((Collection)object, sequence2);
                        return false;
                    }
                }
                return super.visit(x, ctx2);
            }

            public boolean visit(@NotNull JsReturn x, @NotNull JsContext<?> ctx2) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx2.removeMe();
                    return false;
                }
                return super.visit(x, ctx2);
            }

            public boolean visit(@NotNull JsVars x, @NotNull JsContext<?> ctx2) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx2.removeMe();
                    return false;
                }
                return super.visit(x, ctx2);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx2) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
                return false;
            }
        }.accept((JsNode)this.root);
    }

    private final void generateDeclarations() {
        int index2 = 0;
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.usages.values()), (Function1)generateDeclarations.1.INSTANCE), (Function1)generateDeclarations.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Usage.VariableDeclaration it = (Usage.VariableDeclaration)element$iv;
            boolean bl = false;
            JsVars jsVars = JsAstUtils.newVar(it.getTarget(), null);
            Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"newVar(it.target, null)");
            JsVars statement2 = jsVars;
            MetadataProperties.setSynthetic(statement2, this.syntheticNames.contains(it.getTarget()));
            int n = index2;
            index2 = n + 1;
            this.root.getStatements().add(n, statement2);
        }
    }

    private final boolean tryRecord(JsExpression expr, Usage usage) {
        if (!(expr instanceof JsNameRef)) {
            return false;
        }
        JsName jsName = ((JsNameRef)expr).getName();
        if (jsName == null) {
            return false;
        }
        Object object = jsName;
        Object name = object;
        if (!this.namesToProcess.contains(name)) {
            return false;
        }
        object = this.usages;
        boolean bl = false;
        object.put(name, usage);
        return true;
    }

    private final void use(JsName name) {
        Map<JsName, Integer> map = this.referenceCount;
        Integer n = this.referenceCount.get(name);
        n = 1 + (n == null ? 0 : n);
        boolean bl = false;
        map.put(name, n);
    }

    public static final /* synthetic */ boolean access$tryRecord(TemporaryAssignmentElimination $this, JsExpression expr, Usage usage) {
        return $this.tryRecord(expr, usage);
    }

    public static final /* synthetic */ Set access$getSyntheticNames$p(TemporaryAssignmentElimination $this) {
        return $this.syntheticNames;
    }

    public static final /* synthetic */ Set access$getNamesToProcess$p(TemporaryAssignmentElimination $this) {
        return $this.namesToProcess;
    }

    public static final /* synthetic */ void access$use(TemporaryAssignmentElimination $this, JsName name) {
        $this.use(name);
    }

    public static final /* synthetic */ UsageSequence access$getUsageSequence(TemporaryAssignmentElimination $this, JsName name) {
        return $this.getUsageSequence(name);
    }

    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryAssignmentElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryAssignmentElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "getStatement", "()Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "PropertyMutation", "Return", "VariableAssignment", "VariableDeclaration", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "js.translator"})
    private static abstract class Usage {
        @NotNull
        private final JsStatement statement;

        private Usage(JsStatement statement2) {
            this.statement = statement2;
        }

        @NotNull
        public final JsStatement getStatement() {
            return this.statement;
        }

        public /* synthetic */ Usage(JsStatement statement2, DefaultConstructorMarker $constructor_marker) {
            this(statement2);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "js.translator"})
        public static final class Return
        extends Usage {
            public Return(@NotNull JsStatement statement2) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                super(statement2, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
        public static final class VariableAssignment
        extends Usage {
            @NotNull
            private final JsName target;

            public VariableAssignment(@NotNull JsStatement statement2, @NotNull JsName target) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
        public static final class VariableDeclaration
        extends Usage {
            @NotNull
            private final JsName target;
            private int count;

            public VariableDeclaration(@NotNull JsStatement statement2, @NotNull JsName target) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
        public static final class PropertyMutation
        extends Usage {
            @NotNull
            private final JsExpression target;

            public PropertyMutation(@NotNull JsStatement statement2, @NotNull JsExpression target) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }

            @NotNull
            public final JsExpression getTarget() {
                return this.target;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "", "value", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "next", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;)V", "getNext", "()Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "getValue", "()Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "collectStatements", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "lastUsage", "js.translator"})
    private static final class UsageSequence {
        @NotNull
        private final Usage value;
        @Nullable
        private final UsageSequence next;

        public UsageSequence(@NotNull Usage value2, @Nullable UsageSequence next) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.value = value2;
            this.next = next;
        }

        @NotNull
        public final Usage getValue() {
            return this.value;
        }

        @Nullable
        public final UsageSequence getNext() {
            return this.next;
        }

        @NotNull
        public final Sequence<JsStatement> collectStatements() {
            return SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)this, (Function1)collectStatements.1.INSTANCE), (Function1)collectStatements.2.INSTANCE);
        }

        @NotNull
        public final Usage lastUsage() {
            return ((UsageSequence)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)this, (Function1)((Function1)lastUsage.1.INSTANCE)))).value;
        }
    }
}

