/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.SortedMap;
import org.gradle.internal.ExtendedOptional;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.changes.ChangeDetectorVisitor;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.CurrentSnapshotResult;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class StoreExecutionStateStep<C extends BeforeExecutionContext>
implements Step<C, CurrentSnapshotResult> {
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public StoreExecutionStateStep(Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(UnitOfWork work, C context) {
        CurrentSnapshotResult result = this.delegate.execute(work, context);
        context.getHistory().ifPresent(history -> ExtendedOptional.extend(result.getAfterExecutionState()).ifPresentOrElse(afterExecutionState -> {
            boolean shouldStore;
            boolean bl = shouldStore = result.getExecutionResult().isSuccessful() || context.getPreviousExecutionState().map(previewExecutionState -> StoreExecutionStateStep.didOutputsChange(previewExecutionState.getOutputFilesProducedByWork(), afterExecutionState.getOutputFilesProducedByWork())).orElse(true) != false;
            if (shouldStore) {
                history.store(context.getIdentity().getUniqueId(), result.getOriginMetadata(), result.getExecutionResult().isSuccessful(), (AfterExecutionState)afterExecutionState);
            }
        }, () -> history.remove(context.getIdentity().getUniqueId())));
        return result;
    }

    private static boolean didOutputsChange(ImmutableSortedMap<String, FileSystemSnapshot> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        if (!previous.keySet().equals((Object)current.keySet())) {
            return true;
        }
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        OutputFileChanges changes = new OutputFileChanges((SortedMap<String, FileSystemSnapshot>)previous, (SortedMap<String, FileSystemSnapshot>)current);
        changes.accept(visitor);
        return visitor.hasAnyChanges();
    }
}

