/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.hashing.ConfigurableNormalizer;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.EmptyCurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public abstract class AbstractFingerprintingStrategy
implements FingerprintingStrategy {
    private final String identifier;
    private final CurrentFileCollectionFingerprint emptyFingerprint;
    private final DirectorySensitivity directorySensitivity;
    private final HashCode configurationHash;

    public AbstractFingerprintingStrategy(String identifier, DirectorySensitivity directorySensitivity, ConfigurableNormalizer contentNormalizer) {
        this.identifier = identifier;
        this.emptyFingerprint = new EmptyCurrentFileCollectionFingerprint(identifier);
        this.directorySensitivity = directorySensitivity;
        Hasher hasher = Hashing.newHasher();
        hasher.putString((CharSequence)this.getClass().getName());
        contentNormalizer.appendConfigurationToHasher(hasher);
        this.configurationHash = hasher.hash();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public CurrentFileCollectionFingerprint getEmptyFingerprint() {
        return this.emptyFingerprint;
    }

    @Nullable
    protected HashCode getNormalizedContentHash(FileSystemLocationSnapshot snapshot, FileSystemLocationSnapshotHasher normalizedContentHasher) {
        try {
            return normalizedContentHasher.hash(snapshot);
        }
        catch (IOException e) {
            throw new UncheckedIOException(AbstractFingerprintingStrategy.failedToNormalize(snapshot), e);
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(AbstractFingerprintingStrategy.failedToNormalize(snapshot), e.getCause());
        }
    }

    private static String failedToNormalize(FileSystemLocationSnapshot snapshot) {
        return String.format("Failed to normalize content of '%s'.", snapshot.getAbsolutePath());
    }

    protected DirectorySensitivity getDirectorySensitivity() {
        return this.directorySensitivity;
    }

    @Override
    public HashCode getConfigurationHash() {
        return this.configurationHash;
    }
}

