/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.util.PathUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance(VfsUtilCore.class);

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file2, boolean strict) {
        VirtualFile parent2;
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(1);
        }
        if (!file2.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile2 = parent2 = strict ? file2.getParent() : file2;
        while (parent2 != null) {
            if (parent2.equals(ancestor)) {
                return true;
            }
            parent2 = parent2.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file2, @Nullable Set<? extends VirtualFile> roots2) {
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(2);
        }
        if (roots2 == null || roots2.isEmpty()) {
            return false;
        }
        for (VirtualFile parent2 = file2; parent2 != null; parent2 = parent2.getParent()) {
            if (!roots2.contains(parent2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file2, @NotNull VirtualFile ancestor, char separator) {
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(11);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(12);
        }
        if (!file2.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent2 = file2;
        while (true) {
            if (parent2 == null) {
                return null;
            }
            if (parent2.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent2.getNameSequence().length();
            parent2 = parent2.getParent();
        }
        char[] chars = new char[length];
        int index2 = chars.length;
        parent2 = file2;
        while (!parent2.equals(ancestor)) {
            if (index2 < length) {
                chars[--index2] = separator;
            }
            CharSequence name = parent2.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index2] = name.charAt(i);
            }
            parent2 = parent2.getParent();
        }
        return StringFactory.createShared(chars);
    }

    @Nullable
    public static String findRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (src == null) {
            VfsUtilCore.$$$reportNull$$$0(13);
        }
        if (dst == null) {
            VfsUtilCore.$$$reportNull$$$0(14);
        }
        if (!src.getFileSystem().equals(dst.getFileSystem())) {
            return null;
        }
        if (!src.isDirectory() && (src = src.getParent()) == null) {
            return null;
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor(src, dst);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Comparing.equal(src, commonAncestor)) {
            while (!Comparing.equal(src, commonAncestor)) {
                buffer.append("..").append(separatorChar);
                src = src.getParent();
            }
        }
        buffer.append(VfsUtilCore.getRelativePath(dst, commonAncestor, separatorChar));
        if (StringUtil.endsWithChar(buffer, separatorChar)) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path2 = entryVFile.getPath();
        int separatorIndex = path2.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path2.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(15);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(16);
        }
        return VfsUtilCore.copyFile(requestor, file2, toDir, file2.getName());
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull @NonNls String newName2) throws IOException {
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(17);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(18);
        }
        if (newName2 == null) {
            VfsUtilCore.$$$reportNull$$$0(19);
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName2);
        newChild.setBOM(file2.getBOM());
        newChild.setBinaryContent(file2.contentsToByteArray(), -1L, -1L, requestor);
        VirtualFile virtualFile2 = newChild;
        if (virtualFile2 == null) {
            VfsUtilCore.$$$reportNull$$$0(20);
        }
        return virtualFile2;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(byte @NotNull [] buf, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(21);
        }
        if (buf == null) {
            VfsUtilCore.$$$reportNull$$$0(22);
        }
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM(stream, file2);
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file2) throws IOException {
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(24);
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM(stream);
        if (inputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(25);
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file2) throws IOException {
        byte[] bom;
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(27);
        }
        if ((bom = file2.getBOM()) != null) {
            stream.write(bom);
        }
        OutputStream outputStream2 = stream;
        if (outputStream2 == null) {
            VfsUtilCore.$$$reportNull$$$0(28);
        }
        return outputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file2, @NotNull VirtualFileVisitor<?> visitor2) throws VirtualFileVisitor.VisitorException {
        VirtualFileVisitor.Result result2;
        block22: {
            Object object;
            boolean allowVisitFile;
            boolean pushed;
            block25: {
                int n;
                block26: {
                    block24: {
                        VirtualFile[] children2;
                        block23: {
                            if (file2 == null) {
                                VfsUtilCore.$$$reportNull$$$0(33);
                            }
                            if (visitor2 == null) {
                                VfsUtilCore.$$$reportNull$$$0(34);
                            }
                            ProgressManager.checkCanceled();
                            pushed = false;
                            allowVisitFile = visitor2.allowVisitFile(file2);
                            if (allowVisitFile) {
                                VirtualFileVisitor.Result result3 = visitor2.visitFileEx(file2);
                                if (result3.skipChildren) {
                                    VirtualFileVisitor.Result result4 = result3;
                                    VirtualFileVisitor.Result result5 = result4;
                                    if (result5 == null) {
                                        VfsUtilCore.$$$reportNull$$$0(35);
                                    }
                                    return result5;
                                }
                            }
                            Iterable<VirtualFile> childrenIterable = null;
                            children2 = null;
                            try {
                                if (file2.isValid() && visitor2.allowVisitChildren(file2) && !visitor2.depthLimitReached() && (childrenIterable = visitor2.getChildrenIterable(file2)) == null) {
                                    children2 = file2.getChildren();
                                }
                            }
                            catch (InvalidVirtualFileAccessException e) {
                                LOG.info("Ignoring: " + e.getMessage());
                                VirtualFileVisitor.Result result6 = VirtualFileVisitor.CONTINUE;
                                visitor2.restoreValue(pushed);
                                VirtualFileVisitor.Result result7 = result6;
                                if (result7 == null) {
                                    VfsUtilCore.$$$reportNull$$$0(36);
                                }
                                return result7;
                            }
                            if (childrenIterable == null) break block23;
                            visitor2.saveValue();
                            pushed = true;
                            object = childrenIterable.iterator();
                            break block24;
                        }
                        if (children2 == null || children2.length == 0) break block25;
                        visitor2.saveValue();
                        pushed = true;
                        object = children2;
                        n = ((Object)object).length;
                        break block26;
                    }
                    while (object.hasNext()) {
                        VirtualFile child = (VirtualFile)object.next();
                        VirtualFileVisitor.Result result8 = VfsUtilCore.visitChildrenRecursively(child, visitor2);
                        if (result8.skipToParent == null || Comparing.equal(result8.skipToParent, child)) continue;
                        VirtualFileVisitor.Result result9 = result8;
                        VirtualFileVisitor.Result result10 = result9;
                        if (result10 == null) {
                            VfsUtilCore.$$$reportNull$$$0(37);
                        }
                        return result10;
                    }
                    break block25;
                }
                for (int i = 0; i < n; ++i) {
                    Object child = object[i];
                    VirtualFileVisitor.Result result11 = VfsUtilCore.visitChildrenRecursively((VirtualFile)child, visitor2);
                    if (result11.skipToParent == null || Comparing.equal(result11.skipToParent, child)) continue;
                    VirtualFileVisitor.Result result12 = result11;
                    result2 = result12;
                    break block22;
                }
            }
            if (allowVisitFile) {
                visitor2.afterChildrenVisited(file2);
            }
            object = VirtualFileVisitor.CONTINUE;
            Object object2 = object;
            if (object2 == null) {
                VfsUtilCore.$$$reportNull$$$0(39);
            }
            return object2;
            finally {
                visitor2.restoreValue(pushed);
            }
        }
        if (result2 == null) {
            VfsUtilCore.$$$reportNull$$$0(38);
        }
        return result2;
    }

    public static VirtualFile @NotNull [] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            VfsUtilCore.$$$reportNull$$$0(50);
        }
        VirtualFile[] virtualFileArray = files2.isEmpty() ? VirtualFile.EMPTY_ARRAY : files2.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            VfsUtilCore.$$$reportNull$$$0(51);
        }
        return virtualFileArray;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(53);
        }
        return new File(PathUtil.toPresentableUrl(file2.getUrl()));
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root2, final @NotNull Processor<? super VirtualFile> processor2) {
        if (root2 == null) {
            VfsUtilCore.$$$reportNull$$$0(74);
        }
        if (processor2 == null) {
            VfsUtilCore.$$$reportNull$$$0(75);
        }
        final Ref<Boolean> result2 = Ref.create(true);
        VfsUtilCore.visitChildrenRecursively(root2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!processor2.process(file2)) {
                    result2.set(Boolean.FALSE);
                    VirtualFileVisitor.Result result22 = 2.skipTo(root2);
                    if (result22 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return result22;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return result2.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile parent1;
        if (file1 == null) {
            VfsUtilCore.$$$reportNull$$$0(76);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(77);
        }
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        if (file1.equals(file2)) {
            return file1;
        }
        int depth1 = VfsUtilCore.depth(file1);
        int depth2 = VfsUtilCore.depth(file2);
        VirtualFile parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int depth(VirtualFile file2) {
        int depth = 0;
        while (file2 != null) {
            ++depth;
            file2 = file2.getParent();
        }
        return depth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 84: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 33: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 53: 
            case 56: 
            case 78: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 58: 
            case 59: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 8: 
            case 29: 
            case 31: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eClass";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 50: 
            case 57: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfsUrl";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaUrl";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamSkippingBOM";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "outputStreamAddingBOM";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "visitChildrenRecursively";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFileArray";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToPath";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUrl";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "toIdeaUrl";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromUrl";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "fixIDEAUrl";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponents";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualOrAncestor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeLocation";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRelativePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 84: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "byteStreamSkippingBOM";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamSkippingBOM";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "outputStreamAddingBOM";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "iterateChildrenRecursively";
                break;
            }
            case 33: 
            case 34: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitChildrenRecursively";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenLink";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidLink";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFileArray";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFile";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "pathToUrl";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fileToUrl";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFiles";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "toIdeaUrl";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "fixURLforIDEA";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "convertFromUrl";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "convertToURL";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "fixIDEAUrl";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestor";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPathComponents";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidFiles";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findContainingDirectory";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getRootFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 84: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

