/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirPartiallyResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u000e\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u000e\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u000b*\u00020\u0018\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u000b*\u00020\u0018\u001a\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"RETENTION_PARAMETER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "TARGET_PARAMETER_NAME", "defaultAnnotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "extractClassesFromArgument", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "findArgumentByName", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "name", "getAllowedAnnotationTargets", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getAnnotationByFqName", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getRetention", "Lkotlin/annotation/AnnotationRetention;", "getRetentionAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "getTargetAnnotation", "unfoldArrayOrVararg", "checkers"})
public final class FirAnnotationHelpersKt {
    @NotNull
    private static final Name RETENTION_PARAMETER_NAME;
    @NotNull
    private static final Name TARGET_PARAMETER_NAME;
    @NotNull
    private static final Set<KotlinTarget> defaultAnnotationTargets;

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirAnnotationCall $this$getRetention, @NotNull FirSession session2) {
        FirRegularClass annotationClass;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$getRetention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Object object = FirTypeUtilsKt.getConeType($this$getRetention.getAnnotationTypeRef());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
        FirRegularClass firRegularClass = coneClassLikeType == null ? null : ((object = coneClassLikeType.getLookupTag()) == null ? null : ((firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2)) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir()));
        firRegularClass = annotationClass = firRegularClass instanceof FirRegularClass ? (FirRegularClass)firRegularClass : null;
        return firRegularClass == null ? AnnotationRetention.RUNTIME : FirAnnotationHelpersKt.getRetention(firRegularClass);
    }

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirRegularClass $this$getRetention) {
        AnnotationRetention annotationRetention;
        FirExpression firExpression2;
        block4: {
            String string2;
            FirResolvedNamedReference firResolvedNamedReference;
            FirQualifiedAccessExpression firQualifiedAccessExpression;
            Intrinsics.checkNotNullParameter((Object)$this$getRetention, (String)"<this>");
            FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getRetentionAnnotation($this$getRetention);
            if (firAnnotationCall == null) {
                return AnnotationRetention.RUNTIME;
            }
            FirAnnotationCall retentionAnnotation = firAnnotationCall;
            firExpression2 = FirAnnotationHelpersKt.findArgumentByName(retentionAnnotation, RETENTION_PARAMETER_NAME);
            FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            if (firQualifiedAccessExpression == null) {
                return AnnotationRetention.RUNTIME;
            }
            FirQualifiedAccessExpression retentionArgument = firQualifiedAccessExpression;
            Object object = retentionArgument.getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            String string3 = firResolvedNamedReference == null ? null : (string2 = (object = firResolvedNamedReference.getName()) == null ? null : object.asString());
            if (string2 == null) {
                return AnnotationRetention.RUNTIME;
            }
            FirExpression retentionName = firExpression2 = string2;
            AnnotationRetention[] $this$firstOrNull$iv = AnnotationRetention.values();
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv;
            int n = ((AnnotationRetention[])object).length;
            for (int i = 0; i < n; ++i) {
                AnnotationRetention element$iv;
                AnnotationRetention it = element$iv = object[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)retentionName)) continue;
                annotationRetention = element$iv;
                break block4;
            }
            annotationRetention = null;
        }
        firExpression2 = annotationRetention;
        return firExpression2 == null ? AnnotationRetention.RUNTIME : firExpression2;
    }

    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirAnnotationCall $this$getAllowedAnnotationTargets, @NotNull FirSession session2) {
        FirRegularClass annotationClass;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$getAllowedAnnotationTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if ($this$getAllowedAnnotationTargets.getAnnotationTypeRef() instanceof FirErrorTypeRef) {
            return ArraysKt.toSet((Object[])KotlinTarget.values());
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType($this$getAllowedAnnotationTargets.getAnnotationTypeRef());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        FirRegularClass firRegularClass = coneClassLikeType == null ? null : ((coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, session2, null, 2, null)) == null ? null : ((coneClassLikeLookupTag = ((ConeClassLikeType)coneKotlinType).getLookupTag()) == null ? null : ((firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2)) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir())));
        firRegularClass = annotationClass = firRegularClass instanceof FirRegularClass ? (FirRegularClass)firRegularClass : null;
        return firRegularClass == null ? defaultAnnotationTargets : FirAnnotationHelpersKt.getAllowedAnnotationTargets(firRegularClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirRegularClass $this$getAllowedAnnotationTargets) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getAllowedAnnotationTargets, (String)"<this>");
        FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getTargetAnnotation($this$getAllowedAnnotationTargets);
        if (firAnnotationCall == null) {
            return defaultAnnotationTargets;
        }
        FirAnnotationCall targetAnnotation = firAnnotationCall;
        if (targetAnnotation.getArgumentList().getArguments().isEmpty()) {
            return SetsKt.emptySet();
        }
        Object object = FirAnnotationHelpersKt.findArgumentByName(targetAnnotation, TARGET_PARAMETER_NAME);
        object = object == null ? null : FirAnnotationHelpersKt.unfoldArrayOrVararg((FirExpression)object);
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object arguments2 = object2;
        object = (Iterable)arguments2;
        bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget kotlinTarget;
            block7: {
                String string2;
                KotlinTarget[] kotlinTargetArray;
                FirQualifiedAccessExpression targetExpression;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                FirExpression argument2 = (FirExpression)element$iv;
                boolean bl3 = false;
                FirQualifiedAccessExpression firQualifiedAccessExpression = targetExpression = argument2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)argument2 : null;
                Object object3 = firQualifiedAccessExpression == null ? null : firQualifiedAccessExpression.getCalleeReference();
                KotlinTarget[] kotlinTargetArray2 = kotlinTargetArray = object3 instanceof FirResolvedNamedReference ? (KotlinTarget[])object3 : null;
                String string3 = kotlinTargetArray == null ? null : (string2 = (object3 = kotlinTargetArray.getName()) == null ? null : ((Name)object3).asString());
                if (string2 == null) {
                    kotlinTarget = null;
                } else {
                    String string4;
                    String targetName = string4 = string2;
                    KotlinTarget[] $this$firstOrNull$iv = KotlinTarget.values();
                    boolean $i$f$firstOrNull = false;
                    kotlinTargetArray = $this$firstOrNull$iv;
                    int n = kotlinTargetArray.length;
                    for (int i = 0; i < n; ++i) {
                        KotlinTarget element$iv2;
                        KotlinTarget target = element$iv2 = kotlinTargetArray[i];
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)target.name(), (Object)targetName)) continue;
                        kotlinTarget = element$iv2;
                        break block7;
                    }
                    kotlinTarget = null;
                }
            }
            if (kotlinTarget == null) continue;
            KotlinTarget kotlinTarget2 = kotlinTarget;
            boolean bl5 = false;
            boolean bl6 = false;
            KotlinTarget it$iv = kotlinTarget2;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    @Nullable
    public static final FirAnnotationCall getRetentionAnnotation(@NotNull FirAnnotatedDeclaration $this$getRetentionAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getRetentionAnnotation, (String)"<this>");
        return FirAnnotationHelpersKt.getAnnotationByFqName($this$getRetentionAnnotation, StandardNames.FqNames.retention);
    }

    @Nullable
    public static final FirAnnotationCall getTargetAnnotation(@NotNull FirAnnotatedDeclaration $this$getTargetAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetAnnotation, (String)"<this>");
        return FirAnnotationHelpersKt.getAnnotationByFqName($this$getTargetAnnotation, StandardNames.FqNames.target);
    }

    @Nullable
    public static final FirAnnotationCall getAnnotationByFqName(@NotNull FirAnnotationContainer $this$getAnnotationByFqName, @NotNull FqName fqName2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotationByFqName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Iterable iterable = $this$getAnnotationByFqName.getAnnotations();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ClassId classId;
                ConeClassLikeType coneClassLikeType;
                FirAnnotationCall it = (FirAnnotationCall)t;
                boolean bl3 = false;
                Object object = FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef());
                ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
                if (!Intrinsics.areEqual(coneClassLikeType == null ? null : ((object = coneClassLikeType.getLookupTag()) == null ? null : ((classId = ((ConeClassLikeLookupTag)object).getClassId()) == null ? null : classId.asSingleFqName())), (Object)fqName2)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final FirExpression findArgumentByName(@NotNull FirAnnotationCall $this$findArgumentByName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)$this$findArgumentByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object $this$argumentMapping$iv = $this$findArgumentByName;
        boolean $i$f$getArgumentMapping2 = false;
        FirArgumentList argumentList$iv2 = $this$argumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> argumentMapping = argumentList$iv2 instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv2).getMapping() : (argumentList$iv2 instanceof FirPartiallyResolvedArgumentList ? ((FirPartiallyResolvedArgumentList)argumentList$iv2).getMapping() : null);
        if (argumentMapping != null) {
            FirExpression firExpression2;
            block3: {
                Iterable<FirExpression> $i$f$getArgumentMapping2 = argumentMapping.keySet();
                Intrinsics.checkNotNullExpressionValue($i$f$getArgumentMapping2, (String)"argumentMapping.keys");
                $i$f$getArgumentMapping2 = $i$f$getArgumentMapping2;
                boolean argumentList$iv2 = false;
                Iterable<FirExpression> iterable = $i$f$getArgumentMapping2;
                boolean bl = false;
                Iterator<FirExpression> iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    FirExpression firExpression3;
                    FirExpression it = firExpression3 = iterator2.next();
                    boolean bl2 = false;
                    FirValueParameter firValueParameter = argumentMapping.get(it);
                    if (!Intrinsics.areEqual((Object)(firValueParameter == null ? null : firValueParameter.getName()), (Object)name)) continue;
                    firExpression2 = firExpression3;
                    break block3;
                }
                firExpression2 = null;
            }
            $this$argumentMapping$iv = firExpression2;
            return $this$argumentMapping$iv == null ? null : FirExpressionUtilKt.unwrapArgument((FirExpression)$this$argumentMapping$iv);
        }
        FirCall $this$arguments$iv = $this$findArgumentByName;
        boolean $i$f$getArguments = false;
        for (FirExpression argument2 : $this$arguments$iv.getArgumentList().getArguments()) {
            if (!(argument2 instanceof FirNamedArgumentExpression) || !Intrinsics.areEqual((Object)((FirNamedArgumentExpression)argument2).getName(), (Object)name)) continue;
            return ((FirNamedArgumentExpression)argument2).getExpression();
        }
        FirCall $this$arguments$iv2 = $this$findArgumentByName;
        boolean $i$f$getArguments2 = false;
        return (FirExpression)CollectionsKt.singleOrNull($this$arguments$iv2.getArgumentList().getArguments());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirRegularClassSymbol> extractClassesFromArgument(@NotNull FirExpression $this$extractClassesFromArgument) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$extractClassesFromArgument, (String)"<this>");
        Iterable $this$mapNotNull$iv = FirAnnotationHelpersKt.unfoldArrayOrVararg($this$extractClassesFromArgument);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirRegularClassSymbol firRegularClassSymbol;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof FirGetClassCall)) {
                firRegularClassSymbol = null;
            } else {
                FirResolvedQualifier qualifier;
                Object object;
                FirExpression firExpression2 = ((FirGetClassCall)it).getArgument();
                Object object2 = object = firExpression2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression2 : null;
                firRegularClassSymbol = object == null ? null : ((object = (qualifier = object).getSymbol()) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null);
            }
            if (firRegularClassSymbol == null) continue;
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
            boolean bl3 = false;
            boolean bl4 = false;
            FirRegularClassSymbol it$iv$iv = firRegularClassSymbol2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<FirExpression> unfoldArrayOrVararg(FirExpression $this$unfoldArrayOrVararg) {
        List<FirExpression> list2;
        FirExpression firExpression2 = $this$unfoldArrayOrVararg;
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            list2 = ((FirVarargArgumentsExpression)$this$unfoldArrayOrVararg).getArguments();
        } else if (firExpression2 instanceof FirArrayOfCall) {
            FirCall $this$arguments$iv = (FirCall)((Object)$this$unfoldArrayOrVararg);
            boolean $i$f$getArguments = false;
            list2 = $this$arguments$iv.getArgumentList().getArguments();
        } else {
            return CollectionsKt.emptyList();
        }
        return list2;
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"value\")");
        RETENTION_PARAMETER_NAME = name;
        name = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"allowedTargets\")");
        TARGET_PARAMETER_NAME = name;
        defaultAnnotationTargets = KotlinTarget.Companion.getDEFAULT_TARGET_SET();
    }
}

