/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.contracts.description;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionElement;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionVisitor;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeReturnsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeValueParameterReference;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\f\u0010,\u001a\u00020\u000f*\u00020\nH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractRenderer;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionVisitor;", "", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "inBracketsIfNecessary", "parent", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "child", "block", "Lkotlin/Function0;", "needsBrackets", "", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "visitValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "isAtom", "tree"})
public final class ConeContractRenderer
extends ConeContractDescriptionVisitor {
    @NotNull
    private final StringBuilder builder;

    public ConeContractRenderer(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this.builder = builder2;
    }

    public void visitConditionalEffectDeclaration(@NotNull ConeConditionalEffectDeclaration conditionalEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)conditionalEffect, (String)"conditionalEffect");
        conditionalEffect.getEffect().accept(this, data);
        this.builder.append(" -> ");
        conditionalEffect.getCondition().accept(this, data);
    }

    public void visitReturnsEffectDeclaration(@NotNull ConeReturnsEffectDeclaration returnsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)returnsEffect, (String)"returnsEffect");
        this.builder.append("Returns(");
        returnsEffect.getValue().accept(this, data);
        this.builder.append(")");
    }

    public void visitCallsEffectDeclaration(@NotNull ConeCallsEffectDeclaration callsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)callsEffect, (String)"callsEffect");
        this.builder.append("CallsInPlace(");
        callsEffect.getValueParameterReference().accept(this, data);
        this.builder.append(", " + (Object)((Object)callsEffect.getKind()) + ')');
    }

    public void visitLogicalBinaryOperationContractExpression(@NotNull ConeBinaryLogicExpression binaryLogicExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
        this.inBracketsIfNecessary(binaryLogicExpression, binaryLogicExpression.getLeft(), (Function0<Unit>)((Function0)new Function0<Unit>(binaryLogicExpression, this, data){
            final /* synthetic */ ConeBinaryLogicExpression $binaryLogicExpression;
            final /* synthetic */ ConeContractRenderer this$0;
            final /* synthetic */ Void $data;
            {
                this.$binaryLogicExpression = $binaryLogicExpression;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$binaryLogicExpression.getLeft().accept(this.this$0, this.$data);
            }
        }));
        this.builder.append(' ' + binaryLogicExpression.getKind().getToken() + ' ');
        this.inBracketsIfNecessary(binaryLogicExpression, binaryLogicExpression.getRight(), (Function0<Unit>)((Function0)new Function0<Unit>(binaryLogicExpression, this, data){
            final /* synthetic */ ConeBinaryLogicExpression $binaryLogicExpression;
            final /* synthetic */ ConeContractRenderer this$0;
            final /* synthetic */ Void $data;
            {
                this.$binaryLogicExpression = $binaryLogicExpression;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$binaryLogicExpression.getRight().accept(this.this$0, this.$data);
            }
        }));
    }

    public void visitLogicalNot(@NotNull ConeLogicalNot logicalNot, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)logicalNot, (String)"logicalNot");
        this.inBracketsIfNecessary(logicalNot, logicalNot.getArg(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ConeContractRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConeContractRenderer.access$getBuilder$p(this.this$0).append("!");
            }
        }));
        logicalNot.getArg().accept(this, data);
    }

    public void visitIsInstancePredicate(@NotNull ConeIsInstancePredicate isInstancePredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
        isInstancePredicate.getArg().accept(this, data);
        this.builder.append(' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + isInstancePredicate.getType());
    }

    public void visitIsNullPredicate(@NotNull ConeIsNullPredicate isNullPredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)isNullPredicate, (String)"isNullPredicate");
        isNullPredicate.getArg().accept(this, data);
        this.builder.append(' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null");
    }

    public void visitConstantDescriptor(@NotNull ConeConstantReference constantReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)constantReference, (String)"constantReference");
        this.builder.append(constantReference.getName());
    }

    public void visitValueParameterReference(@NotNull ConeValueParameterReference valueParameterReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)valueParameterReference, (String)"valueParameterReference");
        this.builder.append(valueParameterReference.getName());
    }

    private final void inBracketsIfNecessary(ConeContractDescriptionElement parent2, ConeContractDescriptionElement child, Function0<Unit> block) {
        if (this.needsBrackets(parent2, child)) {
            this.builder.append("(");
            block.invoke();
            this.builder.append(")");
        } else {
            block.invoke();
        }
    }

    private final boolean isAtom(ConeContractDescriptionElement $this$isAtom) {
        return $this$isAtom instanceof ConeValueParameterReference || $this$isAtom instanceof ConeConstantReference || $this$isAtom instanceof ConeIsNullPredicate || $this$isAtom instanceof ConeIsInstancePredicate;
    }

    private final boolean needsBrackets(ConeContractDescriptionElement parent2, ConeContractDescriptionElement child) {
        if (this.isAtom(child)) {
            return false;
        }
        if (parent2 instanceof ConeLogicalNot) {
            return true;
        }
        return !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(parent2.getClass()), (Object)Reflection.getOrCreateKotlinClass(child.getClass()));
    }

    public static final /* synthetic */ StringBuilder access$getBuilder$p(ConeContractRenderer $this) {
        return $this.builder;
    }
}

