/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.DefaultComponentSelection;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentSelectionRulesProcessor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultMetadataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ComponentSelectionContext;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.util.internal.CollectionUtils;

class DefaultVersionedComponentChooser
implements VersionedComponentChooser {
    private final ComponentSelectionRulesProcessor rulesProcessor = new ComponentSelectionRulesProcessor();
    private final VersionComparator versionComparator;
    private final ComponentSelectionRulesInternal componentSelectionRules;
    private final VersionParser versionParser;
    private final AttributesSchemaInternal attributesSchema;

    DefaultVersionedComponentChooser(VersionComparator versionComparator, VersionParser versionParser, ComponentSelectionRulesInternal componentSelectionRules, AttributesSchema attributesSchema) {
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.componentSelectionRules = componentSelectionRules;
        this.attributesSchema = (AttributesSchemaInternal)attributesSchema;
    }

    @Override
    public ComponentResolveMetadata selectNewestComponent(@Nullable ComponentResolveMetadata one, @Nullable ComponentResolveMetadata two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        int comparison = this.versionComparator.compare(new VersionInfo(this.versionParser.transform(one.getModuleVersionId().getVersion())), new VersionInfo(this.versionParser.transform(two.getModuleVersionId().getVersion())));
        if (comparison == 0) {
            if (this.isMissingModuleDescriptor(one) && !this.isMissingModuleDescriptor(two)) {
                return two;
            }
            return one;
        }
        return comparison < 0 ? two : one;
    }

    private boolean isMissingModuleDescriptor(ComponentResolveMetadata componentResolveMetadata) {
        return componentResolveMetadata.isMissing();
    }

    @Override
    public void selectNewestMatchingComponent(Collection<? extends ModuleComponentResolveState> versions, ComponentSelectionContext result, VersionSelector requestedVersionMatcher, VersionSelector rejectedVersionSelector, ImmutableAttributes consumerAttributes) {
        Collection<SpecRuleAction<? super ComponentSelection>> rules = this.componentSelectionRules.getRules();
        List<ModuleComponentResolveState> resolveStates = this.sortLatestFirst(versions);
        Action<? super ArtifactResolutionDetails> contentFilter = result.getContentFilter();
        for (ModuleComponentResolveState candidate : resolveStates) {
            if (contentFilter != null) {
                DynamicArtifactResolutionDetails details = new DynamicArtifactResolutionDetails(candidate, result.getConfigurationName(), result.getConsumerAttributes());
                contentFilter.execute((Object)details);
                if (!details.found) continue;
            }
            DefaultMetadataProvider metadataProvider = DefaultVersionedComponentChooser.createMetadataProvider(candidate);
            boolean versionMatches = DefaultVersionedComponentChooser.versionMatches(requestedVersionMatcher, candidate, metadataProvider);
            if (this.metadataIsNotUsable(result, metadataProvider)) {
                return;
            }
            ModuleComponentIdentifier candidateId = candidate.getId();
            if (!versionMatches) {
                result.notMatched(candidateId, requestedVersionMatcher);
                continue;
            }
            RejectedByAttributesVersion maybeRejectByAttributes = this.tryRejectByAttributes(candidateId, metadataProvider, consumerAttributes);
            if (maybeRejectByAttributes != null) {
                result.doesNotMatchConsumerAttributes(maybeRejectByAttributes);
                continue;
            }
            if (this.isRejectedBySelector(candidateId, rejectedVersionSelector)) {
                result.rejectedBySelector(candidateId, rejectedVersionSelector);
                continue;
            }
            RejectedByRuleVersion rejectedByRules = this.isRejectedByRule(candidateId, rules, metadataProvider);
            if (rejectedByRules != null) {
                result.rejectedByRule(rejectedByRules);
                if (!requestedVersionMatcher.matchesUniqueVersion()) continue;
                break;
            }
            result.matches(candidateId);
            return;
        }
        result.noMatchFound();
    }

    @Nullable
    private RejectedByAttributesVersion tryRejectByAttributes(ModuleComponentIdentifier id, MetadataProvider provider, ImmutableAttributes consumerAttributes) {
        if (consumerAttributes.isEmpty()) {
            return null;
        }
        ComponentMetadata componentMetadata = provider.getComponentMetadata();
        if (componentMetadata != null) {
            AttributeContainerInternal attributes = (AttributeContainerInternal)componentMetadata.getAttributes();
            boolean matching = this.attributesSchema.matcher().isMatching(attributes, (AttributeContainerInternal)consumerAttributes);
            if (!matching) {
                return new RejectedByAttributesVersion(id, this.attributesSchema.matcher().describeMatching(attributes, (AttributeContainerInternal)consumerAttributes));
            }
        }
        return null;
    }

    private boolean metadataIsNotUsable(ComponentSelectionContext result, DefaultMetadataProvider metadataProvider) {
        if (!metadataProvider.isUsable()) {
            DefaultVersionedComponentChooser.applyTo(metadataProvider, result);
            return true;
        }
        return false;
    }

    private static DefaultMetadataProvider createMetadataProvider(ModuleComponentResolveState candidate) {
        return new DefaultMetadataProvider(candidate);
    }

    private static void applyTo(DefaultMetadataProvider provider, ComponentSelectionContext result) {
        BuildableModuleComponentMetaDataResolveResult metaDataResult = provider.getResult();
        switch (metaDataResult.getState()) {
            case Unknown: 
            case Missing: {
                result.noMatchFound();
                break;
            }
            case Failed: {
                result.failed(metaDataResult.getFailure());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected meta-data resolution result.");
            }
        }
    }

    private static boolean versionMatches(VersionSelector selector, ModuleComponentResolveState component, MetadataProvider metadataProvider) {
        if (selector.requiresMetadata()) {
            ComponentMetadata componentMetadata = metadataProvider.getComponentMetadata();
            return componentMetadata != null && selector.accept(componentMetadata);
        }
        return selector.accept(component.getVersion());
    }

    @Override
    public RejectedByRuleVersion isRejectedComponent(ModuleComponentIdentifier candidateIdentifier, MetadataProvider metadataProvider) {
        return this.isRejectedByRule(candidateIdentifier, this.componentSelectionRules.getRules(), metadataProvider);
    }

    @Nullable
    private RejectedByRuleVersion isRejectedByRule(ModuleComponentIdentifier candidateIdentifier, Collection<SpecRuleAction<? super ComponentSelection>> rules, MetadataProvider metadataProvider) {
        DefaultComponentSelection selection = new DefaultComponentSelection(candidateIdentifier, metadataProvider);
        this.rulesProcessor.apply(selection, rules, metadataProvider);
        if (selection.isRejected()) {
            return new RejectedByRuleVersion(candidateIdentifier, selection.getRejectionReason());
        }
        return null;
    }

    private boolean isRejectedBySelector(ModuleComponentIdentifier candidateIdentifier, VersionSelector rejectedVersionSelector) {
        return rejectedVersionSelector != null && rejectedVersionSelector.accept(candidateIdentifier.getVersion());
    }

    private List<ModuleComponentResolveState> sortLatestFirst(Collection<? extends ModuleComponentResolveState> listing) {
        return CollectionUtils.sort(listing, Collections.reverseOrder(this.versionComparator));
    }

    private static class DynamicArtifactResolutionDetails
    implements ArtifactResolutionDetails {
        private final ModuleComponentResolveState resolveState;
        private final String configurationName;
        private final ImmutableAttributes consumerAttributes;
        boolean found = true;

        public DynamicArtifactResolutionDetails(ModuleComponentResolveState resolveState, String configurationName, ImmutableAttributes consumerAttributes) {
            this.resolveState = resolveState;
            this.configurationName = configurationName;
            this.consumerAttributes = consumerAttributes;
        }

        @Override
        public ModuleIdentifier getModuleId() {
            return this.resolveState.getId().getModuleIdentifier();
        }

        @Override
        @Nullable
        public ModuleComponentIdentifier getComponentId() {
            return this.resolveState.getId();
        }

        @Override
        public AttributeContainer getConsumerAttributes() {
            return this.consumerAttributes;
        }

        @Override
        public String getConsumerName() {
            return this.configurationName;
        }

        @Override
        public boolean isVersionListing() {
            return false;
        }

        @Override
        public void notFound() {
            this.found = false;
        }
    }
}

