/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.gradle.ProjectPublications;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;

public class ModelMapping {
    private static final Map<Class<?>, String> MODEL_VERSIONS = new HashMap();

    private static void addModelVersions(Map<Class<?>, String> map) {
        map.put(HierarchicalEclipseProject.class, "1.0-milestone-3");
        map.put(EclipseProject.class, "1.0-milestone-3");
        map.put(IdeaProject.class, "1.0-milestone-5");
        map.put(GradleProject.class, "1.0-milestone-5");
        map.put(BasicIdeaProject.class, "1.0-milestone-5");
        map.put(BuildEnvironment.class, "1.0-milestone-8");
        map.put(Void.class, "1.0-milestone-3");
        map.put(GradleBuild.class, "1.8");
        map.put(ProjectPublications.class, "1.12");
    }

    public ModelIdentifier getModelIdentifierFromModelType(Class<?> modelType) {
        if (modelType.equals(Void.class)) {
            return new DefaultModelIdentifier(ModelIdentifier.NULL_MODEL);
        }
        return new DefaultModelIdentifier(modelType.getName());
    }

    @Nullable
    public String getVersionAdded(Class<?> modelType) {
        return MODEL_VERSIONS.get(modelType);
    }

    static {
        ModelMapping.addModelVersions(MODEL_VERSIONS);
    }

    private static class DefaultModelIdentifier
    implements ModelIdentifier {
        private final String model;

        public DefaultModelIdentifier(String model) {
            this.model = model;
        }

        public String toString() {
            return "tooling model " + this.model;
        }

        @Override
        public String getName() {
            return this.model;
        }
    }
}

