/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.AbstractIncludedBuildController;
import org.gradle.composite.internal.DefaultIncludedBuildController;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.composite.internal.RootBuildController;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultIncludedBuildControllers
implements IncludedBuildControllers {
    private final Map<BuildIdentifier, IncludedBuildController> buildControllers = new LinkedHashMap<BuildIdentifier, IncludedBuildController>();
    private final ManagedExecutor executorService;
    private final ProjectStateRegistry projectStateRegistry;
    private final WorkerLeaseService workerLeaseService;
    private final BuildStateRegistry buildRegistry;

    DefaultIncludedBuildControllers(ManagedExecutor executorService, BuildStateRegistry buildRegistry, ProjectStateRegistry projectStateRegistry, WorkerLeaseService workerLeaseService) {
        this.executorService = executorService;
        this.buildRegistry = buildRegistry;
        this.projectStateRegistry = projectStateRegistry;
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    public IncludedBuildController getBuildController(BuildIdentifier buildId) {
        AbstractIncludedBuildController newBuildController;
        IncludedBuildController buildController = this.buildControllers.get(buildId);
        if (buildController != null) {
            return buildController;
        }
        if (buildId.equals(DefaultBuildIdentifier.ROOT)) {
            newBuildController = new RootBuildController(this.buildRegistry.getRootBuild());
        } else {
            IncludedBuildState build = this.buildRegistry.getIncludedBuild(buildId);
            newBuildController = new DefaultIncludedBuildController(build, this.projectStateRegistry, this.workerLeaseService);
        }
        this.buildControllers.put(buildId, newBuildController);
        return newBuildController;
    }

    @Override
    public void populateTaskGraphs() {
        boolean tasksDiscovered = true;
        while (tasksDiscovered) {
            tasksDiscovered = false;
            for (IncludedBuildController buildController : ImmutableList.copyOf(this.buildControllers.values())) {
                if (!buildController.populateTaskGraph()) continue;
                tasksDiscovered = true;
            }
        }
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.prepareForExecution();
        }
    }

    @Override
    public void startTaskExecution() {
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.startTaskExecution((ExecutorService)this.executorService);
        }
    }

    @Override
    public ExecutionResult<Void> awaitTaskCompletion() {
        ExecutionResult result = ExecutionResult.succeeded();
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            result = result.withFailures(buildController.awaitTaskCompletion());
        }
        return result;
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.buildControllers.values()).stop();
    }
}

