/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.ConfigurableIncludedPluginBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.Actions;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.plugin.management.PluginResolutionStrategy;
import org.gradle.plugin.management.internal.PluginManagementSpecInternal;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependency;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;

public class DefaultPluginManagementSpec
implements PluginManagementSpecInternal {
    private final PluginRepositoryHandlerProvider pluginRepositoryHandlerProvider;
    private final PluginResolutionStrategyInternal pluginResolutionStrategy;
    private final PluginDependenciesSpec pluginDependenciesSpec;
    private final FileResolver fileResolver;
    private final BuildIncluder buildIncluder;
    private final GradleInternal gradle;
    private final List<IncludedBuildSpec> includedBuildSpecs = new ArrayList<IncludedBuildSpec>();

    public DefaultPluginManagementSpec(PluginRepositoryHandlerProvider pluginRepositoryHandlerProvider, PluginResolutionStrategyInternal pluginResolutionStrategy, FileResolver fileResolver, BuildIncluder buildIncluder, GradleInternal gradle) {
        this.pluginRepositoryHandlerProvider = pluginRepositoryHandlerProvider;
        this.pluginResolutionStrategy = pluginResolutionStrategy;
        this.fileResolver = fileResolver;
        this.buildIncluder = buildIncluder;
        this.gradle = gradle;
        this.pluginDependenciesSpec = new PluginDependenciesSpecImpl();
    }

    public void repositories(Action<? super RepositoryHandler> repositoriesAction) {
        repositoriesAction.execute((Object)this.getRepositories());
    }

    public RepositoryHandler getRepositories() {
        return this.pluginRepositoryHandlerProvider.getPluginRepositoryHandler();
    }

    public void resolutionStrategy(Action<? super PluginResolutionStrategy> action) {
        action.execute((Object)this.pluginResolutionStrategy);
    }

    public PluginResolutionStrategyInternal getResolutionStrategy() {
        return this.pluginResolutionStrategy;
    }

    public void plugins(Action<? super PluginDependenciesSpec> action) {
        action.execute((Object)this.pluginDependenciesSpec);
    }

    public PluginDependenciesSpec getPlugins() {
        return this.pluginDependenciesSpec;
    }

    public void includeBuild(String rootProject) {
        this.includeBuild(rootProject, (Action<ConfigurableIncludedPluginBuild>)Actions.doNothing());
    }

    public void includeBuild(String rootProject, Action<ConfigurableIncludedPluginBuild> configuration) {
        File projectDir = this.fileResolver.resolve((Object)rootProject);
        IncludedBuildSpec buildSpec = IncludedBuildSpec.includedPluginBuild((File)projectDir, configuration);
        this.buildIncluder.registerPluginBuild(buildSpec, this.gradle);
        this.includedBuildSpecs.add(buildSpec);
    }

    public List<IncludedBuildSpec> getIncludedBuilds() {
        return this.includedBuildSpecs;
    }

    private class PluginDependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;

        private PluginDependencySpecImpl(PluginId id) {
            this.id = id;
        }

        public PluginDependencySpec version(String version) {
            DefaultPluginManagementSpec.this.pluginResolutionStrategy.setDefaultPluginVersion(this.id, version);
            return this;
        }

        public PluginDependencySpec apply(boolean apply) {
            if (apply) {
                throw new IllegalArgumentException("Cannot apply a plugin from within a pluginManagement block.");
            }
            return this;
        }
    }

    private class PluginDependenciesSpecImpl
    implements PluginDependenciesSpec {
        private PluginDependenciesSpecImpl() {
        }

        public PluginDependencySpec id(String id) {
            return new PluginDependencySpecImpl(DefaultPluginId.of((String)id));
        }

        public PluginDependencySpec alias(Provider<PluginDependency> notation) {
            PluginDependency pluginDependency = (PluginDependency)notation.get();
            return this.id(pluginDependency.getPluginId()).version(pluginDependency.getVersion().getRequiredVersion());
        }

        public PluginDependencySpec alias(ProviderConvertible<PluginDependency> notation) {
            return this.alias((Provider<PluginDependency>)notation.asProvider());
        }
    }
}

