/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.MaybeCompressedFileResource;
import org.gradle.api.internal.file.UnknownBackingFileReadableResource;
import org.gradle.api.internal.file.archive.TarFileTree;
import org.gradle.api.internal.file.archive.ZipFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.FileCopier;
import org.gradle.api.internal.file.delete.DefaultDeleteSpec;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.internal.LocalResourceAdapter;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.local.LocalFileStandInExternalResource;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GFileUtils;

public class DefaultFileOperations
implements FileOperations {
    private final FileResolver fileResolver;
    private final TemporaryFileProvider temporaryFileProvider;
    private final Instantiator instantiator;
    private final Deleter deleter;
    private final ResourceHandler resourceHandler;
    private final StreamHasher streamHasher;
    private final FileHasher fileHasher;
    private final Factory<PatternSet> patternSetFactory;
    private final FileCopier fileCopier;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProviderFactory providers;

    public DefaultFileOperations(FileResolver fileResolver, TemporaryFileProvider temporaryFileProvider, Instantiator instantiator, DirectoryFileTreeFactory directoryFileTreeFactory, StreamHasher streamHasher, FileHasher fileHasher, DefaultResourceHandler.Factory resourceHandlerFactory, FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, FileSystem fileSystem, Factory<PatternSet> patternSetFactory, Deleter deleter, DocumentationRegistry documentationRegistry, ProviderFactory providers) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileResolver = fileResolver;
        this.temporaryFileProvider = temporaryFileProvider;
        this.instantiator = instantiator;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.resourceHandler = resourceHandlerFactory.create(this);
        this.streamHasher = streamHasher;
        this.fileHasher = fileHasher;
        this.patternSetFactory = patternSetFactory;
        this.providers = providers;
        this.fileCopier = new FileCopier(deleter, directoryFileTreeFactory, fileCollectionFactory, fileResolver, patternSetFactory, objectFactory, fileSystem, instantiator, documentationRegistry);
        this.fileSystem = fileSystem;
        this.deleter = deleter;
    }

    @Override
    public File file(Object path) {
        return this.fileResolver.resolve(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileResolver.resolve(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileResolver.resolveUri(path);
    }

    @Override
    public ConfigurableFileCollection configurableFiles(Object ... paths) {
        return this.fileCollectionFactory.configurableFiles().from(paths);
    }

    @Override
    public FileCollection immutableFiles(Object ... paths) {
        return this.fileCollectionFactory.resolving((Object)paths);
    }

    @Override
    public PatternSet patternSet() {
        return (PatternSet)this.patternSetFactory.create();
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        ConfigurableFileTree fileTree = this.fileCollectionFactory.fileTree();
        fileTree.from(baseDir);
        return fileTree;
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        ConfigurableFileTree fileTree = this.fileCollectionFactory.fileTree();
        ConfigureUtil.configureByMap(args, (Object)fileTree);
        return fileTree;
    }

    public FileTreeInternal zipTree(Object zipPath) {
        Provider<File> fileProvider = this.asFileProvider(zipPath);
        return new FileTreeAdapter((MinimalFileTree)new ZipFileTree(fileProvider, this.getExpandDir(), (Chmod)this.fileSystem, this.directoryFileTreeFactory, this.fileHasher), this.patternSetFactory);
    }

    public FileTreeInternal tarTree(Object tarPath) {
        Provider<File> fileProvider = this.asFileProvider(tarPath);
        Provider resource = this.providers.provider(() -> {
            if (tarPath instanceof ReadableResourceInternal) {
                return (ReadableResourceInternal)tarPath;
            }
            if (tarPath instanceof ReadableResource) {
                return new UnknownBackingFileReadableResource((ReadableResource)tarPath);
            }
            File tarFile = this.file(tarPath);
            return new LocalResourceAdapter((LocalBinaryResource)new LocalFileStandInExternalResource(tarFile, this.fileSystem));
        });
        if (tarPath instanceof ReadableResource) {
            boolean hasBackingFile;
            boolean bl = hasBackingFile = tarPath instanceof ReadableResourceInternal && ((ReadableResourceInternal)tarPath).getBackingFile() != null;
            if (!hasBackingFile) {
                DeprecationLogger.deprecateAction((String)"Using tarTree() on a resource without a backing file").withAdvice("Convert the resource to a file and then pass this file to tarTree(). For converting the resource to a file you can use a custom task or declare a dependency.").willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "tar_tree_no_backing_file").nagUser();
            }
        }
        TarFileTree tarTree = new TarFileTree(fileProvider, (Provider<ReadableResourceInternal>)resource.map(MaybeCompressedFileResource::new), this.getExpandDir(), (Chmod)this.fileSystem, this.directoryFileTreeFactory, this.streamHasher, this.fileHasher);
        return new FileTreeAdapter((MinimalFileTree)tarTree, this.patternSetFactory);
    }

    private Provider<File> asFileProvider(Object path) {
        if (path instanceof ReadableResource) {
            return this.providers.provider(() -> null);
        }
        if (path instanceof Provider) {
            ProviderInternal provider = (ProviderInternal)path;
            Class type = provider.getType();
            if (type != null) {
                if (File.class.isAssignableFrom(type)) {
                    return (Provider)Cast.uncheckedCast((Object)path);
                }
                if (RegularFile.class.isAssignableFrom(type)) {
                    Provider regularFileProvider = (Provider)Cast.uncheckedCast((Object)provider);
                    return regularFileProvider.map(SerializableLambdas.transformer(RegularFile::getAsFile));
                }
            }
            return provider.map(SerializableLambdas.transformer(this::file));
        }
        return this.providers.provider(() -> this.file(path));
    }

    private File getExpandDir() {
        return this.temporaryFileProvider.newTemporaryFile(new String[]{"expandedArchives"});
    }

    @Override
    public String relativePath(Object path) {
        return this.fileResolver.resolveAsRelativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        File dir = this.fileResolver.resolve(path);
        if (dir.isFile()) {
            throw new InvalidUserDataException(String.format("Can't create directory. The path=%s points to an existing file.", path));
        }
        GFileUtils.mkdirs((File)dir);
        return dir;
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.delete((Action<? super DeleteSpec>)((Action)deleteSpec -> deleteSpec.delete(paths).setFollowSymlinks(false))).getDidWork();
    }

    @Override
    public WorkResult delete(Action<? super DeleteSpec> action) {
        DefaultDeleteSpec deleteSpec = new DefaultDeleteSpec();
        action.execute((Object)deleteSpec);
        FileCollectionInternal roots = this.fileCollectionFactory.resolving((Object)deleteSpec.getPaths());
        boolean didWork = false;
        for (File root : roots) {
            try {
                didWork |= this.deleter.deleteRecursively(root, deleteSpec.isFollowSymlinks());
            }
            catch (IOException ex) {
                throw new UncheckedIOException((Throwable)ex);
            }
        }
        return WorkResults.didWork((boolean)didWork);
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileCopier.copy(action);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileCopier.sync(action);
    }

    public CopySpec copySpec(Action<? super CopySpec> action) {
        CopySpec copySpec = this.copySpec();
        action.execute((Object)copySpec);
        return copySpec;
    }

    @Override
    public CopySpec copySpec() {
        return (CopySpec)this.instantiator.newInstance(DefaultCopySpec.class, new Object[]{this.fileCollectionFactory, this.instantiator, this.patternSetFactory});
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public ResourceHandler getResources() {
        return this.resourceHandler;
    }

    public static DefaultFileOperations createSimple(FileResolver fileResolver, FileCollectionFactory fileTreeFactory, ServiceRegistry services) {
        Instantiator instantiator = (Instantiator)services.get(Instantiator.class);
        ObjectFactory objectFactory = (ObjectFactory)services.get(ObjectFactory.class);
        FileSystem fileSystem = (FileSystem)services.get(FileSystem.class);
        DirectoryFileTreeFactory directoryFileTreeFactory = (DirectoryFileTreeFactory)services.get(DirectoryFileTreeFactory.class);
        StreamHasher streamHasher = (StreamHasher)services.get(StreamHasher.class);
        FileHasher fileHasher = (FileHasher)services.get(FileHasher.class);
        ApiTextResourceAdapter.Factory textResourceAdapterFactory = (ApiTextResourceAdapter.Factory)services.get(ApiTextResourceAdapter.Factory.class);
        Factory patternSetFactory = services.getFactory(PatternSet.class);
        Deleter deleter = (Deleter)services.get(Deleter.class);
        DocumentationRegistry documentationRegistry = (DocumentationRegistry)services.get(DocumentationRegistry.class);
        ProviderFactory providers = (ProviderFactory)services.get(ProviderFactory.class);
        DefaultResourceHandler.Factory resourceHandlerFactory = DefaultResourceHandler.Factory.from(fileResolver, fileSystem, null, textResourceAdapterFactory);
        return new DefaultFileOperations(fileResolver, null, instantiator, directoryFileTreeFactory, streamHasher, fileHasher, resourceHandlerFactory, fileTreeFactory, objectFactory, fileSystem, (Factory<PatternSet>)patternSetFactory, deleter, documentationRegistry, providers);
    }
}

