/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkOperationBackOffAndRetry;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class DependencyResolverIvyPublisher
implements IvyPublisher {
    private final NetworkOperationBackOffAndRetry networkOperationBackOffAndRetry = new NetworkOperationBackOffAndRetry();

    @Override
    public void publish(IvyNormalizedPublication publication, IvyArtifactRepository repository) {
        IvyResolver publisher = ((DefaultIvyArtifactRepository)repository).createPublisher();
        IvyPublicationIdentity projectIdentity = publication.getProjectIdentity();
        ModuleComponentIdentifier moduleVersionIdentifier = DefaultModuleComponentIdentifier.newId((ModuleIdentifier)DefaultModuleIdentifier.newId((String)projectIdentity.getOrganisation(), (String)projectIdentity.getModule()), (String)projectIdentity.getRevision());
        for (IvyArtifact artifact : publication.getAllArtifacts()) {
            DefaultModuleComponentArtifactMetadata artifactMetadata = new DefaultModuleComponentArtifactMetadata(moduleVersionIdentifier, this.createIvyArtifact(artifact));
            this.publish(publisher, artifact, (ModuleComponentArtifactMetadata)artifactMetadata);
        }
    }

    private void publish(final IvyResolver publisher, final IvyArtifact artifact, final ModuleComponentArtifactMetadata artifactMetadata) {
        this.networkOperationBackOffAndRetry.withBackoffAndRetry(new Runnable(){

            @Override
            public void run() {
                publisher.publish(artifactMetadata, artifact.getFile());
            }

            public String toString() {
                return "Publish " + artifactMetadata;
            }
        });
    }

    private IvyArtifactName createIvyArtifact(IvyArtifact artifact) {
        return new DefaultIvyArtifactName(artifact.getName(), artifact.getType(), artifact.getExtension(), artifact.getClassifier());
    }
}

