/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "anyIsGeneric", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "hasGenericOuterDeclaration", "hasThrowableSupertype", "checkers"})
public final class FirThrowableSubclassChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirThrowableSubclassChecker INSTANCE = new FirThrowableSubclassChecker();

    private FirThrowableSubclassChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.hasThrowableSupertype(declaration2, context2)) {
            return;
        }
        Object object = declaration2.getTypeParameters();
        boolean bl = false;
        if (!object.isEmpty()) {
            boolean bl2;
            FirDeclaration firDeclaration;
            object = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration2.getTypeParameters());
            DiagnosticReporterKt.reportOn$default(reporter, object == null ? null : object.getSource(), FirErrors.INSTANCE.getGENERIC_THROWABLE_SUBCLASS(), context2, null, 8, null);
            FirDeclaration firDeclaration2 = firDeclaration = declaration2 instanceof FirRegularClass ? (FirRegularClass)declaration2 : null;
            if (firDeclaration == null) {
                bl2 = false;
            } else {
                FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)firDeclaration;
                boolean $i$f$isInner = false;
                bl2 = $this$isInner$iv.getStatus().isInner();
            }
            FirSourceElement source = bl2 ? declaration2.getSource() : (declaration2 instanceof FirAnonymousObject ? ((firDeclaration = (FirDeclaration)CollectionsKt.firstOrNull(declaration2.getDeclarations())) == null ? null : firDeclaration.getSource()) : null);
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), context2, null, 8, null);
        } else if (this.hasGenericOuterDeclaration(declaration2, context2)) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), context2, null, 8, null);
        }
    }

    private final boolean hasThrowableSupertype(FirClass<?> $this$hasThrowableSupertype, CheckerContext context2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes($this$hasThrowableSupertype);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof ConeClassErrorType) && FirHelpersKt.isSubtypeOfThrowable(it, context2.getSession()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasGenericOuterDeclaration(FirClass<?> $this$hasGenericOuterDeclaration, CheckerContext context2) {
        return FirDeclarationUtilKt.getClassId($this$hasGenericOuterDeclaration).isLocal() && this.anyIsGeneric((Collection<? extends FirDeclaration>)context2.getContainingDeclarations());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean anyIsGeneric(Collection<? extends FirDeclaration> $this$anyIsGeneric) {
        boolean bl;
        Iterable $this$any$iv = $this$anyIsGeneric;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if (it instanceof FirTypeParameterRefsOwner) {
                Collection collection = ((FirTypeParameterRefsOwner)((Object)it)).getTypeParameters();
                boolean bl3 = false;
                if (!collection.isEmpty()) {
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

