/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.gradle.internal.watch.vfs.WatchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalFileWatcherUpdater
extends AbstractFileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchicalFileWatcherUpdater.class);
    private final FileWatcher fileWatcher;
    private final FileSystemLocationToWatchValidator locationToWatchValidator;
    private ImmutableSet<File> watchedHierarchies = ImmutableSet.of();

    public HierarchicalFileWatcherUpdater(FileWatcher fileWatcher, FileSystemLocationToWatchValidator locationToWatchValidator, FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies, AbstractFileWatcherUpdater.MovedDirectoryHandler movedDirectoryHandler) {
        super(probeRegistry, watchableHierarchies, movedDirectoryHandler);
        this.fileWatcher = fileWatcher;
        this.locationToWatchValidator = locationToWatchValidator;
    }

    @Override
    protected boolean handleVirtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> removedSnapshots, Collection<FileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        return this.watchableHierarchies.stream().anyMatch(watchableHierarchy -> {
            boolean hasSnapshotsToWatch = root.hasDescendantsUnder(watchableHierarchy.getPath());
            if (this.watchedFiles.contains(watchableHierarchy)) {
                return !hasSnapshotsToWatch;
            }
            return hasSnapshotsToWatch;
        });
    }

    @Override
    public SnapshotHierarchy updateVfsOnBuildFinished(SnapshotHierarchy root, WatchMode watchMode, int maximumNumberOfWatchedHierarchies, List<File> unsupportedFileSystems) {
        SnapshotHierarchy newRoot = super.updateVfsOnBuildFinished(root, watchMode, maximumNumberOfWatchedHierarchies, unsupportedFileSystems);
        LOGGER.info("Watched directory hierarchies: {}", this.watchedHierarchies);
        return newRoot;
    }

    @Override
    protected void updateWatchesOnChangedWatchedFiles(FileHierarchySet newWatchedFiles) {
        List hierarchiesToStartWatching;
        List hierarchiesToStopWatching;
        ImmutableSet<File> oldWatchedHierarchies = this.watchedHierarchies;
        ImmutableSet.Builder watchedHierarchiesBuilder = ImmutableSet.builder();
        newWatchedFiles.visitRoots(absolutePath -> watchedHierarchiesBuilder.add((Object)new File(absolutePath)));
        this.watchedHierarchies = watchedHierarchiesBuilder.build();
        if (this.watchedHierarchies.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        if (!(hierarchiesToStopWatching = (List)oldWatchedHierarchies.stream().filter(oldWatchedHierarchy -> !this.watchedHierarchies.contains(oldWatchedHierarchy)).collect(ImmutableList.toImmutableList())).isEmpty() && !this.fileWatcher.stopWatching((Collection)hierarchiesToStopWatching)) {
            LOGGER.debug("Couldn't stop watching directories: {}", (Object)hierarchiesToStopWatching);
        }
        if (!(hierarchiesToStartWatching = (List)this.watchedHierarchies.stream().filter(newWatchedHierarchy -> !oldWatchedHierarchies.contains(newWatchedHierarchy)).collect(ImmutableList.toImmutableList())).isEmpty()) {
            hierarchiesToStartWatching.forEach(this.locationToWatchValidator::validateLocationToWatch);
            this.fileWatcher.startWatching((Collection)hierarchiesToStartWatching);
        }
        LOGGER.info("Watching {} directory hierarchies to track changes", (Object)this.watchedHierarchies.size());
    }

    @Override
    protected void startWatchingProbeDirectory(File probeDirectory) {
    }

    @Override
    protected void stopWatchingProbeDirectory(File probeDirectory) {
    }

    @Override
    protected WatchableHierarchies.Invalidator createInvalidator() {
        return (location, currentRoot) -> currentRoot.invalidate(location, SnapshotHierarchy.NodeDiffListener.NOOP);
    }

    public static interface FileSystemLocationToWatchValidator {
        public static final FileSystemLocationToWatchValidator NO_VALIDATION = location -> {};

        public void validateLocationToWatch(File var1);
    }
}

