/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.util.LinkedList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.DefaultTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public class TestReport
extends DefaultTask {
    private final DirectoryProperty destinationDir = this.getObjectFactory().directoryProperty();
    private final ConfigurableFileCollection resultDirs = this.getObjectFactory().fileCollection();

    @Inject
    protected BuildOperationExecutor getBuildOperationExecutor() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @ReplacedBy(value="destinationDirectory")
    public File getDestinationDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle8().withDslReference().nagUser();
        return ((Directory)this.getDestinationDirectory().get()).getAsFile();
    }

    public void setDestinationDir(File destinationDir) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.getDestinationDirectory().set(destinationDir);
    }

    @Incubating
    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDir;
    }

    @ReplacedBy(value="testResults")
    public FileCollection getTestResultDirs() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, (String)"testResultDirs").replaceWith((Object)"testResults")).willBeRemovedInGradle8().withDslReference().nagUser();
        return this.resultDirs;
    }

    @Incubating
    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.NONE)
    public ConfigurableFileCollection getTestResults() {
        return this.resultDirs;
    }

    private void addTo(Object result, ConfigurableFileCollection dirs) {
        if (result instanceof Test) {
            Test test = (Test)((Object)result);
            dirs.from(new Object[]{test.getBinaryResultsDirectory()});
        } else if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            for (Object nested : iterable) {
                this.addTo(nested, dirs);
            }
        } else {
            dirs.from(new Object[]{result});
        }
    }

    public void setTestResultDirs(Iterable<File> testResultDirs) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, (String)"testResultDirs").replaceWith((Object)"testResults")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.resultDirs.setFrom(testResultDirs);
    }

    public void reportOn(Object ... results) {
        ((DeprecationMessageBuilder.DeprecateMethod)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(TestReport.class, (String)"reportOn(Object...)").replaceWith((Object)"testResults")).withAdvice("invoke getTestResults().from(Object...) instead, passing references to Test#getBinaryResultsDirectory() as arguments.")).willBeRemovedInGradle8().withDslReference(TestReport.class, "testResults").nagUser();
        for (Object result : results) {
            this.addTo(result, this.getTestResults());
        }
    }

    @TaskAction
    void generateReport() {
        TestResultsProvider resultsProvider;
        block3: {
            resultsProvider = this.createAggregateProvider();
            try {
                if (resultsProvider.isHasResults()) {
                    DefaultTestReport testReport = new DefaultTestReport(this.getBuildOperationExecutor());
                    testReport.generateReport(resultsProvider, ((Directory)this.getDestinationDirectory().get()).getAsFile());
                    break block3;
                }
                this.getLogger().info("{} - no binary test results found in dirs: {}.", (Object)this.getPath(), (Object)this.getTestResults().getFiles());
                this.setDidWork(false);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{resultsProvider}).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable((Object[])new Object[]{resultsProvider}).stop();
    }

    private TestResultsProvider createAggregateProvider() {
        LinkedList resultsProviders = new LinkedList();
        try {
            ConfigurableFileCollection resultDirs = this.getTestResults();
            if (resultDirs.getFiles().size() == 1) {
                return new BinaryResultBackedTestResultsProvider(resultDirs.getSingleFile());
            }
            return new AggregateTestResultsProvider((Iterable)CollectionUtils.collect((Iterable)resultDirs, resultsProviders, (Transformer)new Transformer<TestResultsProvider, File>(){

                public TestResultsProvider transform(File dir) {
                    return new BinaryResultBackedTestResultsProvider(dir);
                }
            }));
        }
        catch (RuntimeException e) {
            CompositeStoppable.stoppable(resultsProviders).stop();
            throw e;
        }
    }
}

