/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.Collection;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.internal.AbstractClassLoaderWorker;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.TransportableActionExecutionSpec;

public class IsolatedClassloaderWorker
extends AbstractClassLoaderWorker {
    private final GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
    private ClassLoader workerClassLoader;
    private boolean reuseClassloader;

    public IsolatedClassloaderWorker(ClassLoader workerClassLoader, ServiceRegistry workServices, ActionExecutionSpecFactory actionExecutionSpecFactory, InstantiatorFactory instantiatorFactory) {
        super(workServices, actionExecutionSpecFactory, instantiatorFactory);
        this.workerClassLoader = workerClassLoader;
    }

    public IsolatedClassloaderWorker(ClassLoader workerClassLoader, ServiceRegistry workServices, ActionExecutionSpecFactory actionExecutionSpecFactory, InstantiatorFactory instantiatorFactory, boolean reuseClassloader) {
        this(workerClassLoader, workServices, actionExecutionSpecFactory, instantiatorFactory);
        this.reuseClassloader = reuseClassloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultWorkResult run(TransportableActionExecutionSpec spec) {
        DefaultWorkResult defaultWorkResult;
        GroovySystemLoader workerClasspathGroovy = this.groovySystemLoaderFactory.forClassLoader(this.workerClassLoader);
        try {
            defaultWorkResult = this.executeInClassLoader(spec, this.workerClassLoader);
        }
        catch (Throwable throwable) {
            workerClasspathGroovy.shutdown();
            if (!this.reuseClassloader) {
                CompositeStoppable.stoppable((Object[])new Object[]{this.workerClassLoader}).stop();
                this.workerClassLoader = null;
            }
            throw throwable;
        }
        workerClasspathGroovy.shutdown();
        if (!this.reuseClassloader) {
            CompositeStoppable.stoppable((Object[])new Object[]{this.workerClassLoader}).stop();
            this.workerClassLoader = null;
        }
        return defaultWorkResult;
    }

    static ClassLoader createIsolatedWorkerClassloader(ClassLoaderStructure classLoaderStructure, ClassLoader workerInfrastructureClassloader, LegacyTypesSupport legacyTypesSupport) {
        return IsolatedClassloaderWorker.createWorkerClassLoaderWithStructure(workerInfrastructureClassloader, classLoaderStructure, legacyTypesSupport);
    }

    private static ClassLoader createWorkerClassLoaderWithStructure(ClassLoader workerInfrastructureClassloader, ClassLoaderStructure classLoaderStructure, LegacyTypesSupport legacyTypesSupport) {
        if (classLoaderStructure.getParent() == null) {
            return IsolatedClassloaderWorker.createClassLoaderFromSpec(workerInfrastructureClassloader, classLoaderStructure.getSpec(), legacyTypesSupport);
        }
        ClassLoader parent = IsolatedClassloaderWorker.createWorkerClassLoaderWithStructure(workerInfrastructureClassloader, classLoaderStructure.getParent(), legacyTypesSupport);
        return IsolatedClassloaderWorker.createClassLoaderFromSpec(parent, classLoaderStructure.getSpec(), legacyTypesSupport);
    }

    private static ClassLoader createClassLoaderFromSpec(ClassLoader parent, ClassLoaderSpec spec, LegacyTypesSupport legacyTypesSupport) {
        if (spec instanceof MixInLegacyTypesClassLoader.Spec) {
            MixInLegacyTypesClassLoader.Spec mixinSpec = (MixInLegacyTypesClassLoader.Spec)spec;
            if (mixinSpec.getClasspath().isEmpty()) {
                return parent;
            }
            return new MixInLegacyTypesClassLoader(parent, (Collection)mixinSpec.getClasspath(), legacyTypesSupport);
        }
        if (spec instanceof VisitableURLClassLoader.Spec) {
            VisitableURLClassLoader.Spec visitableSpec = (VisitableURLClassLoader.Spec)spec;
            if (visitableSpec.getClasspath().isEmpty()) {
                return parent;
            }
            return new VisitableURLClassLoader(visitableSpec.getName(), parent, (Collection)visitableSpec.getClasspath());
        }
        if (spec instanceof FilteringClassLoader.Spec) {
            FilteringClassLoader.Spec filteringSpec = (FilteringClassLoader.Spec)spec;
            if (filteringSpec.isEmpty()) {
                return parent;
            }
            return new FilteringClassLoader(parent, filteringSpec);
        }
        throw new IllegalArgumentException("Can't handle spec of type " + spec.getClass().getName());
    }
}

