/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import org.apache.commons.lang.StringUtils;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaSystemPropertiesProxySettings
implements HttpProxySettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSystemPropertiesProxySettings.class);
    private final HttpProxySettings.HttpProxy proxy;
    private final String propertyPrefix;
    private final int defaultPort;

    public JavaSystemPropertiesProxySettings(String propertyPrefix, int defaultPort) {
        this(propertyPrefix, defaultPort, System.getProperty(propertyPrefix + ".proxyHost"), System.getProperty(propertyPrefix + ".proxyPort"), System.getProperty(propertyPrefix + ".proxyUser"), System.getProperty(propertyPrefix + ".proxyPassword"));
    }

    JavaSystemPropertiesProxySettings(String propertyPrefix, int defaultPort, String proxyHost, String proxyPortString, String proxyUser, String proxyPassword) {
        this.propertyPrefix = propertyPrefix;
        this.defaultPort = defaultPort;
        this.proxy = StringUtils.isBlank((String)proxyHost) ? null : new HttpProxySettings.HttpProxy(proxyHost, this.initProxyPort(proxyPortString), proxyUser, proxyPassword);
    }

    private int initProxyPort(String proxyPortString) {
        if (StringUtils.isBlank((String)proxyPortString)) {
            return this.defaultPort;
        }
        try {
            return Integer.parseInt(proxyPortString);
        }
        catch (NumberFormatException e) {
            String key = this.propertyPrefix + ".proxyPort";
            LOGGER.warn("Invalid value for java system property '{}': '{}'. Value is not a valid number. Default port '{}' will be used.", new Object[]{key, proxyPortString, this.defaultPort});
            return this.defaultPort;
        }
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy() {
        return this.proxy;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    private static String getAndTrimSystemProperty(String key) {
        String value = System.getProperty(key);
        return value != null ? value.trim() : null;
    }
}

