/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInUsageTypeRefChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirOptInUsageTypeRefChecker INSTANCE = new FirOptInUsageTypeRefChecker();

    private FirOptInUsageTypeRefChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirAnnotation lastAnnotationCall;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = source = typeRef.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType coneType = coneClassLikeType;
        for (FirAnnotation annotation2 : typeRef.getAnnotations()) {
            boolean bl;
            CheckerContext it;
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation2, context2.getSession()) == null || annotation2.getUseSiteTarget() != AnnotationUseSiteTarget.RECEIVER) continue;
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotation2);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            it = (CheckerContext)((MutableDiagnosticContext)context2);
            bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", (DiagnosticContext)context2, null, 16, null);
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneType.getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        FirPhaseManagerKt.ensureResolved((FirBasedSymbol)symbol2, FirResolvePhase.STATUS);
        ClassId classId = symbol2.getClassId();
        Object object = CollectionsKt.lastOrNull(context2.getQualifiedAccessOrAnnotationCalls());
        FirAnnotation firAnnotation = lastAnnotationCall = object instanceof FirAnnotation ? (FirAnnotation)object : null;
        if (lastAnnotationCall == null || lastAnnotationCall.getAnnotationTypeRef() != typeRef) {
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) || Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
            } else if (symbol2 instanceof FirRegularClassSymbol && FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((FirRegularClassSymbol)symbol2).getFir(), OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        FirOptInUsageBaseChecker $this$check_u24lambda_u2d1 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set experimentalities = SetsKt.plus($this$check_u24lambda_u2d1.loadExperimentalities((FirBasedSymbol)symbol2, context2, false, null), (Iterable)$this$check_u24lambda_u2d1.loadExperimentalitiesFromConeArguments(context2, ArraysKt.toList((Object[])coneType.getTypeArguments())));
        $this$check_u24lambda_u2d1.reportNotAcceptedExperimentalities(experimentalities, typeRef, context2, reporter);
    }
}

