/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.util.TextOutput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsPolyfillsVisitor;", "", "()V", "polyfills", "", "", "addAllNeededPolyfillsTo", "", "output", "Lorg/jetbrains/kotlin/js/util/TextOutput;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class JsPolyfillsVisitor {
    @NotNull
    private final Set<String> polyfills = new LinkedHashSet();

    public final void visitDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!IrUtilsKt.isEffectivelyExternal(declaration2)) {
            return;
        }
        String string2 = AnnotationUtilsKt.getJsNativeImplementation(declaration2);
        if (string2 == null) {
            return;
        }
        String implementation2 = string2;
        this.polyfills.add(implementation2);
    }

    public final void addAllNeededPolyfillsTo(@NotNull TextOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.polyfills.isEmpty()) {
            return;
        }
        output.print("// region block: polyfills");
        output.print(CollectionsKt.joinToString$default((Iterable)this.polyfills, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        output.print("// endregion\n");
    }
}

