/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.text.TreeFormatter;

@ThreadSafe
public interface WorkSource<T> {
    public State executionState();

    public Selection<T> selectNext();

    public void finishedExecuting(T var1, @Nullable Throwable var2);

    public void abortAllAndFail(Throwable var1);

    public void cancelExecution();

    public boolean allExecutionComplete();

    public void collectFailures(Collection<? super Throwable> var1);

    public Diagnostics healthDiagnostics();

    public static class Diagnostics {
        private final String displayName;
        private final boolean canMakeProgress;
        private final List<String> queuedItems;
        private final List<String> otherItems;

        public Diagnostics(String displayName, boolean canMakeProgress, List<String> queuedItems, List<String> otherItems) {
            this.displayName = displayName;
            this.canMakeProgress = canMakeProgress;
            this.queuedItems = queuedItems;
            this.otherItems = otherItems;
        }

        public Diagnostics(String displayName) {
            this(displayName, true, Collections.emptyList(), Collections.emptyList());
        }

        public boolean canMakeProgress() {
            return this.canMakeProgress;
        }

        public void describeTo(TreeFormatter formatter) {
            if (!this.queuedItems.isEmpty()) {
                formatter.node("Queued nodes for " + this.displayName);
                formatter.startChildren();
                for (String item : this.queuedItems) {
                    formatter.node(item);
                }
                formatter.endChildren();
            }
            if (!this.otherItems.isEmpty()) {
                formatter.node("Non-queued nodes for " + this.displayName);
                formatter.startChildren();
                for (String item : this.otherItems) {
                    formatter.node(item);
                }
                formatter.endChildren();
            }
        }
    }

    public static abstract class Selection<T> {
        private static final Selection<Object> NO_WORK_READY_TO_START = new Selection<Object>(){

            @Override
            public boolean isNoWorkReadyToStart() {
                return true;
            }
        };
        private static final Selection<Object> NO_MORE_WORK_TO_START = new Selection<Object>(){

            @Override
            public boolean isNoMoreWorkToStart() {
                return true;
            }
        };

        public static <S> Selection<S> of(final S item) {
            return new Selection<S>(){

                @Override
                public S getItem() {
                    return item;
                }
            };
        }

        public static <S> Selection<S> noWorkReadyToStart() {
            return (Selection)Cast.uncheckedCast(NO_WORK_READY_TO_START);
        }

        public static <S> Selection<S> noMoreWorkToStart() {
            return (Selection)Cast.uncheckedCast(NO_MORE_WORK_TO_START);
        }

        public boolean isNoWorkReadyToStart() {
            return false;
        }

        public boolean isNoMoreWorkToStart() {
            return false;
        }

        public T getItem() {
            throw new IllegalStateException();
        }
    }

    public static enum State {
        MaybeWorkReadyToStart,
        NoWorkReadyToStart,
        NoMoreWorkToStart;

    }
}

