/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationBuilder;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;

public class ResolvedConfigurationDependencyGraphVisitor
implements DependencyArtifactsVisitor {
    private final ResolvedConfigurationBuilder builder;
    private RootGraphNode root;

    public ResolvedConfigurationDependencyGraphVisitor(ResolvedConfigurationBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        this.builder.newResolvedDependency(node);
        for (DependencyGraphEdge dependencyGraphEdge : node.getIncomingEdges()) {
            Dependency moduleDependency;
            if (dependencyGraphEdge.getFrom() != this.root || (moduleDependency = dependencyGraphEdge.getOriginalDependency()) == null) continue;
            this.builder.addFirstLevelDependency(moduleDependency, node);
        }
    }

    @Override
    public void startArtifacts(RootGraphNode root) {
        this.root = root;
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
        this.builder.addNodeArtifacts(from, artifactSetId);
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
        this.builder.addChild(from, to, artifactSetId);
    }

    @Override
    public void finishArtifacts() {
        this.builder.done(this.root);
    }
}

