/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.Collection;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.Ref;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeRefinementSupport;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorUtilsKt {
    @NotNull
    private static final Name RETENTION_PARAMETER_NAME;

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor $this$fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$fqNameUnsafe, (String)"<this>");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($this$fqNameUnsafe);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(this)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(@NotNull DeclarationDescriptor $this$fqNameSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$fqNameSafe, (String)"<this>");
        FqName fqName2 = DescriptorUtils.getFqNameSafe($this$fqNameSafe);
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameSafe(this)");
        return fqName2;
    }

    @NotNull
    public static final ModuleDescriptor getModule(@NotNull DeclarationDescriptor $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"<this>");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($this$module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(@NotNull ModuleDescriptor $this$resolveTopLevelClass, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$resolveTopLevelClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)topLevelClassFqName, (String)"topLevelClassFqName");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        boolean bl2 = bl = !topLevelClassFqName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"topLevelClassFqName.parent()");
        MemberScope memberScope2 = $this$resolveTopLevelClass.getPackage(fqName2).getMemberScope();
        Name name = topLevelClassFqName.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"topLevelClassFqName.shortName()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, location);
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    @Nullable
    public static final ClassId getClassId(@Nullable ClassifierDescriptor $this$classId) {
        ClassId classId;
        DeclarationDescriptor declarationDescriptor = $this$classId;
        if (declarationDescriptor != null && (declarationDescriptor = declarationDescriptor.getContainingDeclaration()) != null) {
            DeclarationDescriptor owner = declarationDescriptor;
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor2 = owner;
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                classId = new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $this$classId.getName());
            } else if (declarationDescriptor2 instanceof ClassifierDescriptorWithTypeParameters) {
                ClassId classId2 = DescriptorUtilsKt.getClassId(owner);
                classId = classId2 != null ? classId2.createNestedClassId($this$classId.getName()) : null;
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(@NotNull ClassDescriptor $this$getSuperClassNotAny) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuperClassNotAny, (String)"<this>");
        for (KotlinType supertype : $this$getSuperClassNotAny.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier;
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClassOrEnumClass(superClassifier = supertype.getConstructor().getDeclarationDescriptor())) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull DeclarationDescriptor $this$builtIns) {
        Intrinsics.checkNotNullParameter((Object)$this$builtIns, (String)"<this>");
        return DescriptorUtilsKt.getModule($this$builtIns).getBuiltIns();
    }

    public static final boolean declaresOrInheritsDefaultValue(@NotNull ValueParameterDescriptor $this$declaresOrInheritsDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$declaresOrInheritsDefaultValue, (String)"<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$declaresOrInheritsDefaultValue), declaresOrInheritsDefaultValue.1.INSTANCE, declaresOrInheritsDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(\n        listOf(th\u2026eclaresDefaultValue\n    )");
        return bl;
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(@NotNull DeclarationDescriptor $this$parentsWithSelf) {
        Intrinsics.checkNotNullParameter((Object)$this$parentsWithSelf, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentsWithSelf, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(@NotNull DeclarationDescriptor $this$parents) {
        Intrinsics.checkNotNullParameter((Object)$this$parents, (String)"<this>");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf($this$parents), (int)1);
    }

    @NotNull
    public static final CallableMemberDescriptor getPropertyIfAccessor(@NotNull CallableMemberDescriptor $this$propertyIfAccessor) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$propertyIfAccessor, (String)"<this>");
        if ($this$propertyIfAccessor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$propertyIfAccessor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"correspondingProperty");
            callableMemberDescriptor = propertyDescriptor;
        } else {
            callableMemberDescriptor = $this$propertyIfAccessor;
        }
        return callableMemberDescriptor;
    }

    @Nullable
    public static final FqName fqNameOrNull(@NotNull DeclarationDescriptor $this$fqNameOrNull) {
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)$this$fqNameOrNull, (String)"<this>");
        FqNameUnsafe it = fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe($this$fqNameOrNull);
        boolean bl = false;
        FqNameUnsafe fqNameUnsafe2 = it.isSafe() ? fqNameUnsafe : null;
        return fqNameUnsafe2 != null ? fqNameUnsafe2.toSafe() : null;
    }

    @Nullable
    public static final CallableMemberDescriptor firstOverridden(@NotNull CallableMemberDescriptor $this$firstOverridden, boolean useOriginal, @NotNull Function1<? super CallableMemberDescriptor, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$firstOverridden, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        return (CallableMemberDescriptor)DFS.dfs(CollectionsKt.listOf((Object)$this$firstOverridden), new DFS.Neighbors(useOriginal){
            final /* synthetic */ boolean $useOriginal;
            {
                this.$useOriginal = $useOriginal;
            }

            @NotNull
            public final Iterable<CallableMemberDescriptor> getNeighbors(CallableMemberDescriptor current) {
                CallableMemberDescriptor descriptor2;
                CallableMemberDescriptor callableMemberDescriptor;
                if (this.$useOriginal) {
                    CallableMemberDescriptor callableMemberDescriptor2 = current;
                    callableMemberDescriptor = callableMemberDescriptor2 != null ? callableMemberDescriptor2.getOriginal() : null;
                } else {
                    callableMemberDescriptor = current;
                }
                CallableMemberDescriptor callableMemberDescriptor3 = descriptor2 = callableMemberDescriptor;
                Collection<? extends CallableMemberDescriptor> collection = callableMemberDescriptor3 != null ? callableMemberDescriptor3.getOverriddenDescriptors() : null;
                return collection == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)collection;
            }
        }, new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef<CallableMemberDescriptor>)result2, predicate){
            final /* synthetic */ Ref.ObjectRef<CallableMemberDescriptor> $result;
            final /* synthetic */ Function1<CallableMemberDescriptor, Boolean> $predicate;
            {
                this.$result = $result;
                this.$predicate = $predicate;
            }

            public boolean beforeChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                return this.$result.element == null;
            }

            public void afterChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (this.$result.element == null && ((Boolean)this.$predicate.invoke((Object)current)).booleanValue()) {
                    this.$result.element = current;
                }
            }

            @Nullable
            public CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
        });
    }

    public static /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, (Function1<? super CallableMemberDescriptor, Boolean>)function1);
    }

    @Nullable
    public static final ClassDescriptor getAnnotationClass(@NotNull AnnotationDescriptor $this$annotationClass) {
        Intrinsics.checkNotNullParameter((Object)$this$annotationClass, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$annotationClass.getType().getConstructor().getDeclarationDescriptor();
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    @NotNull
    public static final KotlinTypeRefiner getKotlinTypeRefiner(@NotNull ModuleDescriptor $this$getKotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinTypeRefiner, (String)"<this>");
        Ref<TypeRefinementSupport> ref = $this$getKotlinTypeRefiner.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        TypeRefinementSupport refinerCapability = ref != null ? ref.getValue() : null;
        return refinerCapability instanceof TypeRefinementSupport.Enabled ? ((TypeRefinementSupport.Enabled)refinerCapability).getTypeRefiner() : (KotlinTypeRefiner)KotlinTypeRefiner.Default.INSTANCE;
    }

    public static final boolean isTypeRefinementEnabled(@NotNull ModuleDescriptor $this$isTypeRefinementEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeRefinementEnabled, (String)"<this>");
        Ref<TypeRefinementSupport> ref = $this$isTypeRefinementEnabled.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        return ref != null && (ref = ref.getValue()) != null ? ((TypeRefinementSupport)((Object)ref)).isEnabled() : false;
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"value\")");
        RETENTION_PARAMETER_NAME = name;
    }
}

