/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.internal.jacoco.DefaultJacocoCoverageReport;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoCoverageReport;
import org.gradle.testing.jacoco.tasks.JacocoReport;

@Incubating
public abstract class JacocoReportAggregationPlugin
implements Plugin<Project> {
    public static final String JACOCO_AGGREGATION_CONFIGURATION_NAME = "jacocoAggregation";

    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        project.getPluginManager().apply("jvm-ecosystem");
        project.getPluginManager().apply("jacoco");
        Configuration jacocoAggregation = (Configuration)project.getConfigurations().create(JACOCO_AGGREGATION_CONFIGURATION_NAME);
        jacocoAggregation.setDescription("Collects project dependencies for purposes of JaCoCo coverage report aggregation");
        jacocoAggregation.setVisible(false);
        jacocoAggregation.setCanBeConsumed(false);
        jacocoAggregation.setCanBeResolved(false);
        ObjectFactory objects = project.getObjects();
        Configuration sourceDirectoriesConf = (Configuration)project.getConfigurations().create("allCodeCoverageReportSourceDirectories");
        sourceDirectoriesConf.setDescription("Supplies the source directories used to produce all aggregated JaCoCo coverage data reports");
        sourceDirectoriesConf.extendsFrom(new Configuration[]{jacocoAggregation});
        sourceDirectoriesConf.setVisible(false);
        sourceDirectoriesConf.setCanBeConsumed(false);
        sourceDirectoriesConf.setCanBeResolved(true);
        sourceDirectoriesConf.attributes(attributes -> {
            attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objects.named(Bundling.class, "external")));
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "verification")));
            attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objects.named(VerificationType.class, "main-sources")));
        });
        ArtifactView sourceDirectories = sourceDirectoriesConf.getIncoming().artifactView(view -> {
            view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
            view.lenient(true);
        });
        Configuration classDirectoriesConf = (Configuration)project.getConfigurations().create("allCodeCoverageReportClassDirectories");
        classDirectoriesConf.extendsFrom(new Configuration[]{jacocoAggregation});
        classDirectoriesConf.setDescription("Supplies the class directories used to produce all aggregated JaCoCo coverage data reports");
        classDirectoriesConf.setVisible(false);
        classDirectoriesConf.setCanBeConsumed(false);
        classDirectoriesConf.setCanBeResolved(true);
        ArtifactView classDirectories = classDirectoriesConf.getIncoming().artifactView(view -> view.componentFilter(id -> id instanceof ProjectComponentIdentifier));
        ReportingExtension reporting = (ReportingExtension)project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(JacocoCoverageReport.class, DefaultJacocoCoverageReport.class);
        reporting.getReports().withType(JacocoCoverageReport.class).all(report -> {
            Configuration executionDataConf = (Configuration)project.getConfigurations().create(report.getName() + "ExecutionData");
            executionDataConf.extendsFrom(new Configuration[]{jacocoAggregation});
            executionDataConf.setDescription(String.format("Supplies JaCoCo coverage data to the %s.  External library dependencies may appear as resolution failures, but this is expected behavior.", report.getName()));
            executionDataConf.setVisible(false);
            executionDataConf.setCanBeConsumed(false);
            executionDataConf.setCanBeResolved(true);
            executionDataConf.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "verification")));
                attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, report.getTestType().map(tt -> (TestSuiteType)objects.named(TestSuiteType.class, tt)));
                attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objects.named(VerificationType.class, "jacoco-coverage")));
                attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"binary");
            });
            report.getReportTask().configure(task -> {
                Callable<FileCollection> executionData = () -> executionDataConf.getIncoming().artifactView(view -> {
                    view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
                    view.lenient(true);
                }).getFiles();
                this.configureReportTaskInputs((JacocoReport)((Object)((Object)task)), classDirectories, sourceDirectories, executionData);
            });
        });
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            project.getDependencies().add(JACOCO_AGGREGATION_CONFIGURATION_NAME, (Object)project);
            TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "CodeCoverageReport", JacocoCoverageReport.class, report -> report.getTestType().convention((Provider)testSuite.getTestType())));
        });
    }

    private void configureReportTaskInputs(JacocoReport task, ArtifactView classDirectories, ArtifactView sourceDirectories, Callable<FileCollection> executionData) {
        task.getExecutionData().from(new Object[]{executionData});
        task.getClassDirectories().from(new Object[]{classDirectories.getFiles()});
        task.getSourceDirectories().from(new Object[]{sourceDirectories.getFiles()});
    }
}

