/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;

public class OrdinalGroup
extends NodeGroup {
    private final int ordinal;
    private final Set<Node> entryNodes = new LinkedHashSet<Node>();

    public OrdinalGroup(int ordinal) {
        this.ordinal = ordinal;
    }

    public String toString() {
        return "task group " + this.ordinal;
    }

    @Override
    @Nullable
    public OrdinalGroup asOrdinal() {
        return this;
    }

    @Override
    public NodeGroup withOrdinalGroup(OrdinalGroup newOrdinal) {
        return newOrdinal;
    }

    @Override
    public boolean isReachableFromEntryPoint() {
        return true;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrdinalGroup that = (OrdinalGroup)o;
        return this.ordinal == that.ordinal;
    }

    public int hashCode() {
        return this.ordinal;
    }

    public void addEntryNode(Node node) {
        this.entryNodes.add(node);
    }

    public String diagnostics() {
        return "group " + this.ordinal + " entry nodes: " + this.entryNodes;
    }
}

