/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;

class BiProvider<R, A, B>
extends AbstractMinimalProvider<R> {
    private final BiFunction<? super A, ? super B, ? extends R> combiner;
    private final ProviderInternal<A> left;
    private final ProviderInternal<B> right;

    public BiProvider(Provider<A> left, Provider<B> right, BiFunction<? super A, ? super B, ? extends R> combiner) {
        this.combiner = combiner;
        this.left = Providers.internal(left);
        this.right = Providers.internal(right);
    }

    @Override
    public String toString() {
        return String.format("and(%s, %s)", this.left, this.right);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends R> calculateExecutionTimeValue() {
        return this.isChangingValue(this.left) || this.isChangingValue(this.right) ? ValueSupplier.ExecutionTimeValue.changingValue(this) : super.calculateExecutionTimeValue();
    }

    private boolean isChangingValue(ProviderInternal<?> provider) {
        return provider.calculateExecutionTimeValue().isChangingValue();
    }

    @Override
    protected ValueSupplier.Value<? extends R> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<A> lv = this.left.calculateValue(consumer);
        if (lv.isMissing()) {
            return lv.asType();
        }
        ValueSupplier.Value<B> rv = this.right.calculateValue(consumer);
        if (rv.isMissing()) {
            return rv.asType();
        }
        return ValueSupplier.Value.of(this.combiner.apply(lv.get(), rv.get()));
    }

    @Override
    @Nullable
    public Class<R> getType() {
        return null;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new ValueSupplier.PlusProducer(this.left.getProducer(), this.right.getProducer());
    }
}

