/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

public class SourceLocation {
    @Nullable
    private final URI uri;
    private final String scriptSourceDescription;
    private final String expression;
    private final int lineNumber;
    private final int columnNumber;

    public SourceLocation(@Nullable URI uri, String scriptSourceDescription, String expression, int lineNumber, int columnNumber) {
        this.uri = uri;
        this.scriptSourceDescription = scriptSourceDescription;
        this.expression = expression;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public SourceLocation(@Nullable String uri, String scriptSourceDescription, String expression, int lineNumber, int columnNumber) {
        this(uri == null ? null : URI.create(uri), scriptSourceDescription, expression, lineNumber, columnNumber);
    }

    public String getExpression() {
        return this.expression;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Nullable
    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return this.scriptSourceDescription + " line " + this.lineNumber + ", column " + this.columnNumber;
    }

    public ModelRuleDescriptor asDescriptor() {
        return new SimpleModelRuleDescriptor(this.expression + " @ " + this.toString());
    }
}

