/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultExecSpec;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.ProcessStreamsSpec;

public class DefaultJavaExecSpec
extends DefaultJavaForkOptions
implements JavaExecSpec,
ProcessArgumentsSpec.HasExecutable {
    private boolean ignoreExitValue;
    private final ProcessStreamsSpec streamsSpec = new ProcessStreamsSpec();
    private final ProcessArgumentsSpec argumentsSpec = new ProcessArgumentsSpec(this);
    private final Property<String> mainClass;
    private final Property<String> mainModule;
    private final ModularitySpec modularity;
    private final FileCollectionFactory fileCollectionFactory;
    private ConfigurableFileCollection classpath;

    @Inject
    public DefaultJavaExecSpec(ObjectFactory objectFactory, PathToFileResolver resolver, FileCollectionFactory fileCollectionFactory) {
        super(resolver, fileCollectionFactory, (JavaDebugOptions)objectFactory.newInstance(DefaultJavaDebugOptions.class, new Object[0]));
        this.mainClass = objectFactory.property(String.class);
        this.mainModule = objectFactory.property(String.class);
        this.modularity = (ModularitySpec)objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.fileCollectionFactory = fileCollectionFactory;
        this.classpath = fileCollectionFactory.configurableFiles("classpath");
    }

    public void copyTo(JavaExecSpec targetSpec) {
        targetSpec.setArgs(this.getArgs());
        targetSpec.getArgumentProviders().addAll(this.getArgumentProviders());
        targetSpec.getMainClass().set(this.getMainClass());
        targetSpec.getMainModule().set(this.getMainModule());
        targetSpec.getModularity().getInferModulePath().set((Provider)this.getModularity().getInferModulePath());
        targetSpec.classpath(new Object[]{this.getClasspath()});
        DefaultExecSpec.copyBaseExecSpecTo((BaseExecSpec)this, (BaseExecSpec)targetSpec);
        super.copyTo((JavaForkOptions)targetSpec);
    }

    public List<String> getCommandLine() {
        return this.argumentsSpec.getCommandLine();
    }

    public JavaExecSpec args(Object ... args) {
        this.argumentsSpec.args(args);
        return this;
    }

    public JavaExecSpec args(Iterable<?> args) {
        this.argumentsSpec.args(args);
        return this;
    }

    public JavaExecSpec setArgs(@Nullable List<String> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    public JavaExecSpec setArgs(@Nullable Iterable<?> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    @Nullable
    public List<String> getArgs() {
        return this.argumentsSpec.getArgs();
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentsSpec.getArgumentProviders();
    }

    public JavaExecSpec classpath(Object ... paths) {
        this.classpath.from(paths);
        return this;
    }

    public FileCollection getClasspath() {
        return this.classpath;
    }

    public JavaExecSpec setClasspath(FileCollection classpath) {
        this.classpath = this.fileCollectionFactory.configurableFiles("classpath");
        this.classpath.setFrom((Iterable)classpath);
        return this;
    }

    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public JavaExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    public InputStream getStandardInput() {
        return this.streamsSpec.getStandardInput();
    }

    public JavaExecSpec setStandardInput(InputStream standardInput) {
        this.streamsSpec.setStandardInput(standardInput);
        return this;
    }

    public OutputStream getStandardOutput() {
        return this.streamsSpec.getStandardOutput();
    }

    public JavaExecSpec setStandardOutput(OutputStream standardOutput) {
        this.streamsSpec.setStandardOutput(standardOutput);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.streamsSpec.getErrorOutput();
    }

    public JavaExecSpec setErrorOutput(OutputStream errorOutput) {
        this.streamsSpec.setErrorOutput(errorOutput);
        return this;
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public Property<String> getMainModule() {
        return this.mainModule;
    }

    public ModularitySpec getModularity() {
        return this.modularity;
    }
}

