/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.internal.provider.HasConfigurableValueInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.provider.HasConfigurableValue;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.StaticValue;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.bean.RuntimeBeanNode;
import org.gradle.internal.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public abstract class AbstractNestedRuntimeBeanNode
extends RuntimeBeanNode<Object> {
    private final TypeMetadata typeMetadata;

    protected AbstractNestedRuntimeBeanNode(@Nullable RuntimeBeanNode<Object> parentNode, @Nullable String propertyName, Object bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean);
        this.typeMetadata = typeMetadata;
    }

    protected void visitProperties(PropertyVisitor visitor, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory, TypeValidationContext validationContext) {
        this.typeMetadata.visitValidationFailures(this.getPropertyName(), validationContext);
        for (PropertyMetadata propertyMetadata : this.typeMetadata.getPropertiesMetadata()) {
            PropertyAnnotationHandler annotationHandler = this.typeMetadata.getAnnotationHandlerFor(propertyMetadata);
            String propertyName = this.getQualifiedPropertyName(propertyMetadata.getPropertyName());
            PropertyValue value = new BeanPropertyValue(this.getBean(), propertyMetadata.getGetterMethod());
            if (propertyMetadata.isAnnotationPresent(Nested.class)) {
                Object nested;
                try {
                    nested = AbstractNestedRuntimeBeanNode.unpackProvider(value.call());
                }
                catch (Exception e) {
                    visitor.visitInputProperty(propertyName, new InvalidValue(e), false);
                    continue;
                }
                if (nested != null) {
                    queue.add(nodeFactory.create(this, propertyName, nested));
                }
                value = new StaticValue(nested);
            }
            annotationHandler.visitPropertyValue(propertyName, value, propertyMetadata, visitor);
        }
    }

    @Nullable
    private static Object unpackProvider(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).getOrNull();
        }
        return value;
    }

    private static class InvalidValue
    implements PropertyValue {
        private final Exception exception;

        public InvalidValue(Exception exception) {
            this.exception = exception;
        }

        @Override
        @Nullable
        public Object call() {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.exception);
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
        }

        public String toString() {
            return "INVALID: " + this.exception.getMessage();
        }
    }

    private static class BeanPropertyValue
    implements PropertyValue {
        private final Method method;
        private final Object bean;
        private final Supplier<Object> cachedInvoker = Suppliers.memoize((Supplier)new Supplier<Object>(){

            @Nullable
            public Object get() {
                return DeprecationLogger.whileDisabled(() -> {
                    try {
                        return method.invoke(bean, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                    }
                    catch (Exception e) {
                        throw new GradleException(String.format("Could not call %s.%s() on %s", method.getDeclaringClass().getSimpleName(), method.getName(), bean), (Throwable)e);
                    }
                });
            }
        });

        public BeanPropertyValue(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            if (this.isProvider()) {
                return (TaskDependencyContainer)this.cachedInvoker.get();
            }
            if (this.isBuildable()) {
                return context -> {
                    Object dependency = this.cachedInvoker.get();
                    if (dependency != null) {
                        context.add(dependency);
                    }
                };
            }
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
            if (this.isConfigurable()) {
                Object value = this.cachedInvoker.get();
                ((HasConfigurableValueInternal)value).implicitFinalizeValue();
            }
        }

        private boolean isProvider() {
            return Provider.class.isAssignableFrom(this.method.getReturnType());
        }

        private boolean isConfigurable() {
            return HasConfigurableValue.class.isAssignableFrom(this.method.getReturnType());
        }

        private boolean isBuildable() {
            return Buildable.class.isAssignableFrom(this.method.getReturnType());
        }

        @Override
        @Nullable
        public Object call() {
            return this.cachedInvoker.get();
        }

        public String toString() {
            return "Bean: " + this.bean + ", method: " + this.method;
        }
    }
}

