/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LocationInfo;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "cachedLocation", "Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "getCachedLocation", "()Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "cachedLocation$delegate", "Lkotlin/Lazy;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "location", "getLocation", "frontend"})
public final class KotlinLookupLocation
implements LookupLocation {
    @NotNull
    private final KtElement element;
    @NotNull
    private final Lazy cachedLocation$delegate;

    public KotlinLookupLocation(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.cachedLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<cachedLocation.1>(this){
            final /* synthetic */ KotlinLookupLocation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final cachedLocation.1 invoke() {
                KtFile ktFile = this.this$0.getElement().getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
                KtFile containingJetFile = ktFile;
                return KtPsiFactoryKt.getDoNotAnalyze(containingJetFile) != null ? null : new LocationInfo(containingJetFile, this.this$0){
                    @NotNull
                    private final String filePath;
                    final /* synthetic */ KtFile $containingJetFile;
                    final /* synthetic */ KotlinLookupLocation this$0;
                    {
                        this.$containingJetFile = $containingJetFile;
                        this.this$0 = $receiver;
                        this.filePath = $containingJetFile.getVirtualFilePath();
                    }

                    @NotNull
                    public String getFilePath() {
                        return this.filePath;
                    }

                    @NotNull
                    public Position getPosition() {
                        PsiDiagnosticUtils.LineAndColumn it = DiagnosticUtils.getLineAndColumnInPsiFile(this.$containingJetFile, this.this$0.getElement().getTextRange());
                        boolean bl = false;
                        return new Position(it.getLine(), it.getColumn());
                    }
                };
            }
        }));
    }

    @NotNull
    public final KtElement getElement() {
        return this.element;
    }

    @Nullable
    public final LocationInfo getCachedLocation() {
        Lazy lazy = this.cachedLocation$delegate;
        return (LocationInfo)lazy.getValue();
    }

    @Override
    @Nullable
    public LocationInfo getLocation() {
        return this.getCachedLocation();
    }
}

