/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Optional;
import java.util.function.Predicate;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainInstantiationResult;

public class JavaToolchainMatcher
implements Predicate<JavaToolchain> {
    private final JavaToolchainSpec spec;

    public static Predicate<? super JavaToolchainInstantiationResult> forInstantiationResult(JavaToolchainSpec spec) {
        return r -> {
            Optional<JavaToolchain> toolchain = r.getToolchain();
            return toolchain.isPresent() && new JavaToolchainMatcher(spec).test(toolchain.get());
        };
    }

    public JavaToolchainMatcher(JavaToolchainSpec spec) {
        this.spec = spec;
    }

    @Override
    public boolean test(JavaToolchain toolchain) {
        return this.test(toolchain.getMetadata());
    }

    @Override
    public boolean test(JvmInstallationMetadata metadata) {
        Predicate<? super JvmInstallationMetadata> predicate = this.languagePredicate().and(this.vendorPredicate()).and(this.implementationPredicate());
        return predicate.test((JvmInstallationMetadata)metadata);
    }

    private Predicate<JvmInstallationMetadata> languagePredicate() {
        return metadata -> {
            JavaLanguageVersion actualVersion = JavaToolchain.getJavaLanguageVersion(metadata);
            JavaLanguageVersion expectedVersion = (JavaLanguageVersion)this.spec.getLanguageVersion().get();
            return actualVersion.equals(expectedVersion);
        };
    }

    private Predicate<? super JvmInstallationMetadata> implementationPredicate() {
        return metadata -> {
            if (this.spec.getImplementation().get() == JvmImplementation.VENDOR_SPECIFIC) {
                return true;
            }
            boolean j9Requested = JavaToolchainMatcher.isJ9ExplicitlyRequested(this.spec) || JavaToolchainMatcher.isJ9RequestedViaVendor(this.spec);
            boolean isJ9Vm = metadata.hasCapability(JvmInstallationMetadata.JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            return j9Requested == isJ9Vm;
        };
    }

    private static boolean isJ9ExplicitlyRequested(JavaToolchainSpec spec) {
        return spec.getImplementation().get() == JvmImplementation.J9;
    }

    private static boolean isJ9RequestedViaVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        return vendorSpec != DefaultJvmVendorSpec.any() && vendorSpec.test(JvmVendor.KnownJvmVendor.IBM.asJvmVendor());
    }

    private Predicate<JvmInstallationMetadata> vendorPredicate() {
        return (DefaultJvmVendorSpec)this.spec.getVendor().get();
    }
}

