/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.reflect;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.gradle.api.internal.tasks.compile.filter.AnnotationProcessorFilter;
import org.gradle.internal.classpath.ClassPath;

public class GradleStandardJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final ClassPath annotationProcessorPath;
    private final boolean hasEmptySourcePaths;
    private final boolean hasPreviousClassOutput;

    private GradleStandardJavaFileManager(StandardJavaFileManager fileManager, ClassPath annotationProcessorPath, boolean hasEmptySourcePaths, @Nullable File previousClassOutput) {
        super(fileManager);
        this.annotationProcessorPath = annotationProcessorPath;
        this.hasEmptySourcePaths = hasEmptySourcePaths;
        this.hasPreviousClassOutput = previousClassOutput != null;
        this.registerPreviousClassOutput(previousClassOutput);
    }

    private void registerPreviousClassOutput(@Nullable File previousClassOutput) {
        if (previousClassOutput != null) {
            try {
                ((StandardJavaFileManager)this.fileManager).setLocation(GradleLocation.PREVIOUS_CLASS_OUTPUT, Collections.singleton(previousClassOutput));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Problem registering previous class output location", e);
            }
        }
    }

    public static JavaFileManager wrap(StandardJavaFileManager delegate, ClassPath annotationProcessorPath, boolean hasEmptySourcePaths, @Nullable File previousClassOutput) {
        return new GradleStandardJavaFileManager(delegate, annotationProcessorPath, hasEmptySourcePaths, previousClassOutput);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        if (this.hasEmptySourcePaths && location.equals(StandardLocation.SOURCE_PATH)) {
            return false;
        }
        return super.hasLocation(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (this.hasEmptySourcePaths && location.equals(StandardLocation.CLASS_PATH)) {
            kinds.remove((Object)JavaFileObject.Kind.SOURCE);
        }
        if (this.hasPreviousClassOutput && location.equals(StandardLocation.CLASS_OUTPUT)) {
            Iterable<JavaFileObject> previousClassOutput = super.list(GradleLocation.PREVIOUS_CLASS_OUTPUT, packageName, kinds, recurse);
            Iterable<JavaFileObject> classOutput = super.list(location, packageName, kinds, recurse);
            return Iterables.concat(previousClassOutput, classOutput);
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        ClassLoader classLoader = super.getClassLoader(location);
        if (location.equals(StandardLocation.ANNOTATION_PROCESSOR_PATH) && classLoader instanceof URLClassLoader) {
            return new URLClassLoader(this.annotationProcessorPath.getAsURLArray(), (ClassLoader)AnnotationProcessorFilter.getFilteredClassLoader(classLoader.getParent()));
        }
        return classLoader;
    }

    private static enum GradleLocation implements JavaFileManager.Location
    {
        PREVIOUS_CLASS_OUTPUT;


        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    }
}

