/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.CachingResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContextHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.io.IoSupplier;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class DefaultResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private static final HashCode NO_HASH = Hashing.signature((String)(CachingResourceHasher.class.getName() + " : no hash"));
    private final PersistentIndexedCache<HashCode, HashCode> persistentCache;

    public DefaultResourceSnapshotterCacheService(PersistentIndexedCache<HashCode, HashCode> persistentCache) {
        this.persistentCache = persistentCache;
    }

    @Nullable
    public HashCode hashFile(FileSystemLocationSnapshot snapshot, FileSystemLocationSnapshotHasher hasher, HashCode configurationHash) throws IOException {
        return this.hashFile(snapshot, (IoSupplier<HashCode>)((IoSupplier)() -> hasher.hash(snapshot)), configurationHash);
    }

    @Nullable
    public HashCode hashFile(RegularFileSnapshotContext fileSnapshotContext, RegularFileSnapshotContextHasher hasher, HashCode configurationHash) throws IOException {
        return this.hashFile((FileSystemLocationSnapshot)fileSnapshotContext.getSnapshot(), (IoSupplier<HashCode>)((IoSupplier)() -> hasher.hash(fileSnapshotContext)), configurationHash);
    }

    @Nullable
    private HashCode hashFile(FileSystemLocationSnapshot snapshot, IoSupplier<HashCode> hashCodeSupplier, HashCode configurationHash) throws IOException {
        HashCode resourceHashCacheKey = DefaultResourceSnapshotterCacheService.resourceHashCacheKey(snapshot.getHash(), configurationHash);
        HashCode resourceHash = (HashCode)this.persistentCache.getIfPresent((Object)resourceHashCacheKey);
        if (resourceHash != null) {
            if (resourceHash.equals((Object)NO_HASH)) {
                return null;
            }
            return resourceHash;
        }
        resourceHash = (HashCode)hashCodeSupplier.get();
        if (resourceHash != null) {
            this.persistentCache.put((Object)resourceHashCacheKey, (Object)resourceHash);
        } else {
            this.persistentCache.put((Object)resourceHashCacheKey, (Object)NO_HASH);
        }
        return resourceHash;
    }

    private static HashCode resourceHashCacheKey(HashCode contentHash, HashCode configurationHash) {
        Hasher hasher = Hashing.newHasher();
        hasher.putHash(configurationHash);
        hasher.putHash(contentHash);
        return hasher.hash();
    }
}

