/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.util.DescriptorByIdSignatureFinder;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\"H\u0002J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\f*\u00020$2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl;", "Lorg/jetbrains/kotlin/ir/util/DescriptorByIdSignatureFinder;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "lookupMode", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl$LookupMode;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl$LookupMode;)V", "findDescriptorByHash", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "candidates", "", "id", "", "(Ljava/util/Collection;Ljava/lang/Long;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDescriptorBySignature", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "findDescriptorForAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "findDescriptorForPublicSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "isConstructorName", "", "n", "Lorg/jetbrains/kotlin/name/Name;", "performLookup", "nameSegments", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "resolveCompositeSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "loadDescriptors", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "name", "isLeaf", "LookupMode", "ir.serialization.common"})
public final class DescriptorByIdSignatureFinderImpl
implements DescriptorByIdSignatureFinder {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final KotlinMangler.DescriptorMangler mangler;
    @NotNull
    private final LookupMode lookupMode;

    public DescriptorByIdSignatureFinderImpl(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinMangler.DescriptorMangler mangler, @NotNull LookupMode lookupMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupMode), (String)"lookupMode");
        this.moduleDescriptor = moduleDescriptor;
        this.mangler = mangler;
        this.lookupMode = lookupMode;
        boolean bl2 = bl = this.lookupMode != LookupMode.MODULE_ONLY || this.moduleDescriptor instanceof ModuleDescriptorImpl;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Incorrect lookup mode " + (Object)((Object)this.lookupMode) + " for " + this.moduleDescriptor;
            throw new AssertionError((Object)string2);
        }
    }

    public /* synthetic */ DescriptorByIdSignatureFinderImpl(ModuleDescriptor moduleDescriptor, KotlinMangler.DescriptorMangler descriptorMangler, LookupMode lookupMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            lookupMode = LookupMode.MODULE_WITH_DEPENDENCIES;
        }
        this(moduleDescriptor, descriptorMangler, lookupMode);
    }

    @Override
    @Nullable
    public DeclarationDescriptor findDescriptorBySignature(@NotNull IdSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        IdSignature idSignature = signature2;
        if (idSignature instanceof IdSignature.AccessorSignature) {
            declarationDescriptor = this.findDescriptorForAccessorSignature((IdSignature.AccessorSignature)signature2);
        } else if (idSignature instanceof IdSignature.CommonSignature) {
            declarationDescriptor = this.findDescriptorForPublicSignature((IdSignature.CommonSignature)signature2);
        } else if (idSignature instanceof IdSignature.CompositeSignature) {
            declarationDescriptor = this.resolveCompositeSignature((IdSignature.CompositeSignature)signature2);
        } else {
            throw new IllegalStateException(("only PublicSignature or AccessorSignature should reach this point, got " + signature2).toString());
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor resolveCompositeSignature(IdSignature.CompositeSignature signature2) {
        DeclarationDescriptor container = this.findDescriptorBySignature(signature2.nearestPublicSig());
        IdSignature inner = signature2.getInner();
        if (inner instanceof IdSignature.LocalSignature && DescriptorByIdSignatureFinderImpl.resolveCompositeSignature$isTypeParameterSig(((IdSignature.LocalSignature)inner).getLocalFqn())) {
            int tpIndex = ((IdSignature.LocalSignature)inner).index();
            if (container instanceof CallableDescriptor) {
                return ((CallableDescriptor)container).getTypeParameters().get(tpIndex);
            }
            if (container instanceof ClassifierDescriptorWithTypeParameters) {
                return ((ClassifierDescriptorWithTypeParameters)container).getDeclaredTypeParameters().get(tpIndex);
            }
        }
        return container;
    }

    private final DeclarationDescriptor findDescriptorForAccessorSignature(IdSignature.AccessorSignature signature2) {
        Object v2;
        block3: {
            DeclarationDescriptor declarationDescriptor = this.findDescriptorBySignature(signature2.getPropertySignature());
            PropertyDescriptor propertyDescriptor = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
            if (propertyDescriptor == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            String shortName = signature2.getAccessorSignature().getShortName();
            List<PropertyAccessorDescriptor> list2 = propertyDescriptor2.getAccessors();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyDescriptor.accessors");
            Iterable $this$singleOrNull$iv = list2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)shortName)) continue;
                if (found$iv) {
                    v2 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        return v2;
    }

    private final boolean isConstructorName(Name n) {
        return n.isSpecial() && Intrinsics.areEqual((Object)n.asString(), (Object)"<init>");
    }

    private final Collection<DeclarationDescriptor> loadDescriptors(MemberScope $this$loadDescriptors, String name, boolean isLeaf) {
        Name name2 = Name.guessByFirstCharacter(name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(name)");
        Name descriptorName = name2;
        ClassifierDescriptor classifier2 = $this$loadDescriptors.getContributedClassifier(descriptorName, NoLookupLocation.FROM_BACKEND);
        if (!isLeaf) {
            return kotlin.collections.CollectionsKt.listOfNotNull((Object)classifier2);
        }
        List result2 = new ArrayList();
        ClassifierDescriptor classifierDescriptor = classifier2;
        if (classifierDescriptor != null) {
            ClassifierDescriptor it = classifierDescriptor;
            boolean bl = false;
            result2.add(it);
        }
        result2.addAll($this$loadDescriptors.getContributedFunctions(descriptorName, NoLookupLocation.FROM_BACKEND));
        result2.addAll($this$loadDescriptors.getContributedVariables(descriptorName, NoLookupLocation.FROM_BACKEND));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> performLookup(List<String> nameSegments, FqName packageFqName) {
        Collection collection;
        String declarationName = nameSegments.get(0);
        boolean isLeaf = nameSegments.size() == 1;
        switch (WhenMappings.$EnumSwitchMapping$0[this.lookupMode.ordinal()]) {
            case 1: {
                collection = this.loadDescriptors(this.moduleDescriptor.getPackage(packageFqName).getMemberScope(), declarationName, isLeaf);
                break;
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                Intrinsics.checkNotNull((Object)moduleDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl");
                Iterable iterable = PackageFragmentProviderKt.packageFragments(((ModuleDescriptorImpl)moduleDescriptor).getPackageFragmentProviderForModuleContentWithoutDependencies(), packageFqName);
                boolean $i$f$flatMap = false;
                void var7_7 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.loadDescriptors(it.getMemberScope(), declarationName, isLeaf);
                    kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                collection = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor findDescriptorForPublicSignature(IdSignature.CommonSignature signature2) {
        Collection toplevelDescriptors;
        List<String> nameSegments = signature2.getNameSegments();
        Collection collection = this.performLookup(nameSegments, signature2.packageFqName());
        if (collection.isEmpty()) {
            boolean bl = false;
            return null;
        }
        Collection acc = toplevelDescriptors = collection;
        int lastIndex = kotlin.collections.CollectionsKt.getLastIndex(nameSegments);
        int n = nameSegments.size();
        for (int i = 1; i < n; ++i) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)Name.guessByFirstCharacter(nameSegments.get(i)), (String)"guessByFirstCharacter(nameSegments[i])");
            Iterable $this$flatMap$iv = acc;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Object object;
                block9: {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    List list2;
                    ClassifierDescriptor classifier2;
                    Name current;
                    MemberScope memberScope2;
                    ClassDescriptor classDescriptor2;
                    block10: {
                        block11: {
                            block8: {
                                DeclarationDescriptor container = (DeclarationDescriptor)element$iv$iv;
                                boolean bl = false;
                                if ((container instanceof ClassDescriptor ? (ClassDescriptor)container : null) != null) break block8;
                                object = kotlin.collections.CollectionsKt.emptyList();
                                break block9;
                            }
                            classDescriptor2 = classDescriptor2;
                            boolean isLeaf = i == lastIndex;
                            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2.getUnsubstitutedMemberScope(), (String)"classDescriptor.unsubstitutedMemberScope");
                            classifier2 = memberScope2.getContributedClassifier(current, NoLookupLocation.FROM_BACKEND);
                            if (isLeaf) break block10;
                            object = classifier2;
                            if (object == null) break block11;
                            Object it = object;
                            boolean bl2 = false;
                            List list3 = kotlin.collections.CollectionsKt.listOf((Object)it);
                            object = list3;
                            if (list3 != null) break block9;
                        }
                        object = kotlin.collections.CollectionsKt.emptyList();
                        break block9;
                    }
                    List $this$findDescriptorForPublicSignature_u24lambda_u248_u24lambda_u247 = list2 = (List)new ArrayList();
                    boolean bl = false;
                    CollectionsKt.addIfNotNull($this$findDescriptorForPublicSignature_u24lambda_u248_u24lambda_u247, classifier2);
                    if (signature2.getId() != null) {
                        if (this.isConstructorName(current)) {
                            Collection<ClassConstructorDescriptor> collection2 = classDescriptor2.getConstructors();
                            Intrinsics.checkNotNullExpressionValue(collection2, (String)"classDescriptor.constructors");
                            $this$findDescriptorForPublicSignature_u24lambda_u248_u24lambda_u247.addAll(collection2);
                        }
                        $this$findDescriptorForPublicSignature_u24lambda_u248_u24lambda_u247.addAll(memberScope2.getContributedFunctions(current, NoLookupLocation.FROM_BACKEND));
                        $this$findDescriptorForPublicSignature_u24lambda_u248_u24lambda_u247.addAll(memberScope2.getContributedVariables(current, NoLookupLocation.FROM_BACKEND));
                    }
                    MemberScope memberScope3 = classDescriptor2.getStaticScope();
                    Intrinsics.checkNotNullExpressionValue((Object)memberScope3, (String)"classDescriptor.staticScope");
                    Iterable bl2 = ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope3, null, null, 3, null);
                    List list4 = $this$findDescriptorForPublicSignature_u24lambda_u248_u24lambda_u247;
                    boolean $i$f$filter = false;
                    void var28_32 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)current)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    list4.addAll((List)destination$iv$iv2);
                    object = list2;
                }
                Iterable list$iv$iv = (Iterable)object;
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            acc = (List)destination$iv$iv;
        }
        Collection candidates2 = acc;
        return this.findDescriptorByHash(candidates2, signature2.getId());
    }

    private final DeclarationDescriptor findDescriptorByHash(Collection<? extends DeclarationDescriptor> candidates2, Long id) {
        Object v1;
        block3: {
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                DeclarationDescriptor candidate2 = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                if (id == null) {
                    bl = candidate2 instanceof ClassDescriptor || candidate2 instanceof TypeAliasDescriptor;
                } else {
                    KotlinMangler.DescriptorMangler $this$findDescriptorByHash_u24lambda_u2410_u24lambda_u249 = this.mangler;
                    boolean bl3 = false;
                    long candidateHash = $this$findDescriptorByHash_u24lambda_u2410_u24lambda_u249.signatureMangle(candidate2, false);
                    bl = candidateHash == id;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    private static final boolean resolveCompositeSignature$isTypeParameterSig(String fqn) {
        return Intrinsics.areEqual((Object)fqn, (Object)"<TP>") || Intrinsics.areEqual((Object)fqn, (Object)"<STP>");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl$LookupMode;", "", "(Ljava/lang/String;I)V", "MODULE_WITH_DEPENDENCIES", "MODULE_ONLY", "ir.serialization.common"})
    public static final class LookupMode
    extends Enum<LookupMode> {
        public static final /* enum */ LookupMode MODULE_WITH_DEPENDENCIES = new LookupMode();
        public static final /* enum */ LookupMode MODULE_ONLY = new LookupMode();
        private static final /* synthetic */ LookupMode[] $VALUES;

        public static LookupMode[] values() {
            return (LookupMode[])$VALUES.clone();
        }

        public static LookupMode valueOf(String value2) {
            return Enum.valueOf(LookupMode.class, value2);
        }

        static {
            $VALUES = lookupModeArray = new LookupMode[]{LookupMode.MODULE_WITH_DEPENDENCIES, LookupMode.MODULE_ONLY};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LookupMode.values().length];
            try {
                nArray[LookupMode.MODULE_WITH_DEPENDENCIES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LookupMode.MODULE_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

