/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;

public abstract class AbstractJavaCompileSpecFactory<T extends JavaCompileSpec>
implements Factory<T> {
    private final CompileOptions compileOptions;
    private final JavaInstallationMetadata toolchain;

    public AbstractJavaCompileSpecFactory(CompileOptions compileOptions, @Nullable JavaInstallationMetadata toolchain) {
        this.compileOptions = compileOptions;
        this.toolchain = toolchain;
    }

    public T create() {
        if (this.toolchain != null) {
            return this.chooseSpecForToolchain();
        }
        if (this.compileOptions.isFork()) {
            return this.chooseSpecFromCompileOptions(Jvm.current().getJavaHome());
        }
        return this.getDefaultSpec();
    }

    private T chooseSpecForToolchain() {
        File toolchainJavaHome = this.toolchain.getInstallationPath().getAsFile();
        if (!this.toolchain.getLanguageVersion().canCompileOrRun(8)) {
            return this.getCommandLineSpec(Jvm.forHome((File)toolchainJavaHome).getJavacExecutable());
        }
        if (this.compileOptions.isFork()) {
            return this.chooseSpecFromCompileOptions(toolchainJavaHome);
        }
        if (!this.toolchain.isCurrentJvm()) {
            return this.getForkingSpec(toolchainJavaHome);
        }
        return this.getDefaultSpec();
    }

    private T chooseSpecFromCompileOptions(File fallbackJavaHome) {
        File forkJavaHome = this.compileOptions.getForkOptions().getJavaHome();
        if (forkJavaHome != null) {
            return this.getCommandLineSpec(Jvm.forHome((File)forkJavaHome).getJavacExecutable());
        }
        String forkExecutable = this.compileOptions.getForkOptions().getExecutable();
        if (forkExecutable != null) {
            return this.getCommandLineSpec(new File(forkExecutable));
        }
        return this.getForkingSpec(fallbackJavaHome);
    }

    protected abstract T getCommandLineSpec(File var1);

    protected abstract T getForkingSpec(File var1);

    protected abstract T getDefaultSpec();
}

