/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ScriptSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/gradle/kotlin/dsl/execution/ProgramSourceFragment;", "", "source", "Lorg/gradle/kotlin/dsl/execution/ProgramSource;", "section", "Lorg/gradle/kotlin/dsl/execution/ScriptSection;", "(Lorg/gradle/kotlin/dsl/execution/ProgramSource;Lorg/gradle/kotlin/dsl/execution/ScriptSection;)V", "blockString", "", "getBlockString$kotlin_dsl", "()Ljava/lang/String;", "lineNumber", "", "getLineNumber", "()I", "range", "Lkotlin/ranges/IntRange;", "getRange", "()Lkotlin/ranges/IntRange;", "getSection", "()Lorg/gradle/kotlin/dsl/execution/ScriptSection;", "getSource", "()Lorg/gradle/kotlin/dsl/execution/ProgramSource;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "kotlin-dsl"})
public final class ProgramSourceFragment {
    @NotNull
    private final ProgramSource source;
    @NotNull
    private final ScriptSection section;

    public ProgramSourceFragment(@NotNull ProgramSource source, @NotNull ScriptSection section) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        this.source = source;
        this.section = section;
    }

    @NotNull
    public final ProgramSource getSource() {
        return this.source;
    }

    @NotNull
    public final ScriptSection getSection() {
        return this.section;
    }

    public final int getLineNumber() {
        return this.source.getContents().lineNumberOf(this.section.getIdentifier().getFirst());
    }

    @NotNull
    public final IntRange getRange() {
        return this.section.getWholeRange();
    }

    @NotNull
    public String toString() {
        return "ProgramSourceFragment(\"" + StringsKt.subSequence((CharSequence)this.source.getText(), (IntRange)this.getRange()) + "\")";
    }

    @NotNull
    public final String getBlockString$kotlin_dsl() {
        return StringsKt.substring((String)this.source.getText(), (IntRange)this.section.getBlock());
    }

    @NotNull
    public final ProgramSource component1() {
        return this.source;
    }

    @NotNull
    public final ScriptSection component2() {
        return this.section;
    }

    @NotNull
    public final ProgramSourceFragment copy(@NotNull ProgramSource source, @NotNull ScriptSection section) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        return new ProgramSourceFragment(source, section);
    }

    public static /* synthetic */ ProgramSourceFragment copy$default(ProgramSourceFragment programSourceFragment, ProgramSource programSource, ScriptSection scriptSection, int n, Object object) {
        if ((n & 1) != 0) {
            programSource = programSourceFragment.source;
        }
        if ((n & 2) != 0) {
            scriptSection = programSourceFragment.section;
        }
        return programSourceFragment.copy(programSource, scriptSection);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + this.section.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProgramSourceFragment)) {
            return false;
        }
        ProgramSourceFragment programSourceFragment = (ProgramSourceFragment)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)programSourceFragment.source)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.section, (Object)programSourceFragment.section);
    }
}

