/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractPhaseTransformer;", "D", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "baseTransformerPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "getBaseTransformerPhase", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "transformerPhase", "getTransformerPhase", "checkSessionConsistency", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformFile", "data", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "resolve"})
public abstract class FirAbstractPhaseTransformer<D>
extends FirDefaultTransformer<D> {
    @NotNull
    private final FirResolvePhase baseTransformerPhase;

    public FirAbstractPhaseTransformer(@NotNull FirResolvePhase baseTransformerPhase) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)baseTransformerPhase), (String)"baseTransformerPhase");
        this.baseTransformerPhase = baseTransformerPhase;
        boolean bl2 = bl = this.baseTransformerPhase != FirResolvePhase.RAW_FIR;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Raw FIR building shouldn't be done in phase transformer";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    protected final FirResolvePhase getBaseTransformerPhase() {
        return this.baseTransformerPhase;
    }

    @NotNull
    public FirResolvePhase getTransformerPhase() {
        return this.baseTransformerPhase;
    }

    @NotNull
    public abstract FirSession getSession();

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, D data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkSessionConsistency(file2);
        return super.transformFile(file2, data);
    }

    protected final void checkSessionConsistency(@NotNull FirFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl2 = bl = this.getSession() == file2.getModuleData().getSession();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "File " + file2.getName() + " and transformer " + Reflection.getOrCreateKotlinClass(this.getClass()) + " have inconsistent sessions";
            throw new AssertionError((Object)string2);
        }
    }
}

