/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.internal.UncheckedException;

public class TransformationResultSerializer {
    private static final String INPUT_FILE_PATH_PREFIX = "i/";
    private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
    private final File outputDir;

    public TransformationResultSerializer(File outputDir) {
        this.outputDir = outputDir;
    }

    public void writeToFile(File target, TransformationResult result) {
        final String outputDirPrefix = this.outputDir.getPath() + File.separator;
        final ArrayList resultFileContents = new ArrayList(result.size());
        result.visitOutputs(new TransformationResult.TransformationOutputVisitor(){

            @Override
            public void visitEntireInputArtifact() {
                resultFileContents.add(TransformationResultSerializer.INPUT_FILE_PATH_PREFIX);
            }

            @Override
            public void visitPartOfInputArtifact(String relativePath) {
                resultFileContents.add(TransformationResultSerializer.INPUT_FILE_PATH_PREFIX + relativePath);
            }

            @Override
            public void visitProducedOutput(File outputLocation) {
                if (outputLocation.equals(TransformationResultSerializer.this.outputDir)) {
                    resultFileContents.add(TransformationResultSerializer.OUTPUT_FILE_PATH_PREFIX);
                } else {
                    resultFileContents.add(TransformationResultSerializer.OUTPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)outputLocation.getAbsolutePath().substring(outputDirPrefix.length())).getPathString());
                }
            }
        });
        UncheckedException.unchecked(() -> Files.write(target.toPath(), (Iterable<? extends CharSequence>)resultFileContents, new OpenOption[0]));
    }

    public TransformationResult readResultsFile(File resultsFile) {
        Path transformerResultsPath = resultsFile.toPath();
        try {
            TransformationResult.Builder builder = TransformationResult.builder();
            List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
            for (String path : paths) {
                if (path.startsWith(OUTPUT_FILE_PATH_PREFIX)) {
                    builder.addProducedOutput(new File(this.outputDir, path.substring(2)));
                    continue;
                }
                if (path.startsWith(INPUT_FILE_PATH_PREFIX)) {
                    String relativePathString = path.substring(2);
                    if (relativePathString.isEmpty()) {
                        builder.addEntireInputArtifact();
                        continue;
                    }
                    builder.addPartOfInputArtifact(relativePathString);
                    continue;
                }
                throw new IllegalStateException("Cannot parse result path string: " + path);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

