/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy.reflection;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KParameterState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u001cH\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KParameterProxy;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/ReflectionProxy;", "Lkotlin/reflect/KParameter;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KParameterState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "(Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KParameterState;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "annotations", "", "", "getAnnotations", "()Ljava/util/List;", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "index", "", "getIndex", "()I", "isOptional", "", "()Z", "isVararg", "kind", "Lkotlin/reflect/KParameter$Kind;", "getKind", "()Lkotlin/reflect/KParameter$Kind;", "name", "", "getName", "()Ljava/lang/String;", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KParameterState;", "type", "Lkotlin/reflect/KType;", "getType", "()Lkotlin/reflect/KType;", "equals", "other", "", "hashCode", "toString", "ir.interpreter"})
public final class KParameterProxy
implements KParameter,
ReflectionProxy {
    @NotNull
    private final KParameterState state;
    @NotNull
    private final CallInterceptor callInterceptor;

    public KParameterProxy(@NotNull KParameterState state, @NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        this.state = state;
        this.callInterceptor = callInterceptor;
    }

    @Override
    @NotNull
    public KParameterState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    public int getIndex() {
        return this.getState().getIndex();
    }

    @Nullable
    public String getName() {
        return this.getKind() == KParameter.Kind.VALUE ? this.getState().getIrParameter().getName().asString() : null;
    }

    @NotNull
    public KType getType() {
        return this.getState().getType(this.getCallInterceptor());
    }

    @NotNull
    public KParameter.Kind getKind() {
        return this.getState().getKind();
    }

    public boolean isOptional() {
        return this.getState().getIrParameter().getDefaultValue() != null;
    }

    public boolean isVararg() {
        return this.getState().getIrParameter().getVarargElementType() != null;
    }

    @NotNull
    public List<Annotation> getAnnotations() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KParameterProxy)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getState(), (Object)((KParameterProxy)other).getState());
    }

    @Override
    public int hashCode() {
        return this.getState().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getState().toString();
    }
}

