/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import java.util.Date;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class LazyPublishArtifact
implements PublishArtifactInternal {
    private final ProviderInternal<?> provider;
    @Nullable
    private final String version;
    private final FileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;
    private PublishArtifactInternal delegate;

    public LazyPublishArtifact(Provider<? extends AbstractArchiveTask> archiveTask, FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory) {
        this(archiveTask, null, fileResolver, taskDependencyFactory);
    }

    public LazyPublishArtifact(Provider<?> provider, @Nullable String version, FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory) {
        this.provider = Providers.internal(provider);
        this.version = version;
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public String getExtension() {
        return this.getDelegate().getExtension();
    }

    public String getType() {
        return this.getDelegate().getType();
    }

    public String getClassifier() {
        return this.getDelegate().getClassifier();
    }

    public File getFile() {
        return this.getDelegate().getFile();
    }

    public Date getDate() {
        return new Date();
    }

    private PublishArtifactInternal getDelegate() {
        if (this.delegate == null) {
            Object value = this.provider.get();
            if (value instanceof FileSystemLocation) {
                FileSystemLocation location = (FileSystemLocation)value;
                this.delegate = this.fromFile(location.getAsFile());
            } else {
                this.delegate = value instanceof File ? this.fromFile((File)value) : (value instanceof AbstractArchiveTask ? new ArchivePublishArtifact(this.taskDependencyFactory, (AbstractArchiveTask)value) : (value instanceof Task ? this.fromFile(((Task)value).getOutputs().getFiles().getSingleFile()) : this.fromFile(this.fileResolver.resolve(value))));
            }
        }
        return this.delegate;
    }

    private PublishArtifactInternal fromFile(File file) {
        ArtifactFile artifactFile = new ArtifactFile(file, this.version);
        return new DefaultPublishArtifact(this.taskDependencyFactory, artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Object[0]);
    }

    public TaskDependency getBuildDependencies() {
        return this.taskDependencyFactory.visitingDependencies(context -> context.add(this.provider));
    }

    public boolean shouldBePublished() {
        return this.getDelegate().shouldBePublished();
    }
}

