/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.capabilities.MutableCapabilitiesMetadata;
import org.gradle.api.internal.capabilities.CapabilitiesMetadataInternal;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;

public class DefaultMutableCapabilities
implements MutableCapabilitiesMetadata,
CapabilitiesMetadataInternal {
    private final List<Capability> descriptors;

    public DefaultMutableCapabilities(List<Capability> descriptors) {
        this.descriptors = descriptors;
    }

    public void addCapability(String group, String name, String version) {
        for (Capability descriptor : this.descriptors) {
            if (!descriptor.getGroup().equals(group) || !descriptor.getName().equals(name) || descriptor.getVersion().equals(version)) continue;
            throw new InvalidUserDataException("Cannot add capability " + group + ":" + name + " with version " + version + " because it's already defined with version " + descriptor.getVersion());
        }
        this.descriptors.add((Capability)new DefaultImmutableCapability(group, name, version));
    }

    public void removeCapability(String group, String name) {
        this.descriptors.removeIf(next -> next.getGroup().equals(group) && next.getName().equals(name));
    }

    public CapabilitiesMetadata asImmutable() {
        return ImmutableCapabilities.of(this.getCapabilities());
    }

    public List<? extends Capability> getCapabilities() {
        return ImmutableList.copyOf(this.descriptors);
    }
}

