/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.internal.DefaultJvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.DefaultJvmLanguageGeneratedSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.DefaultJvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.DefaultJvmVariantBuilder;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.JvmLanguageGeneratedSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.instantiation.InstanceGenerator;

public class DefaultJvmPluginServices
implements JvmPluginServices {
    private final ConfigurationContainer configurations;
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;
    private final TaskContainer tasks;
    private final SoftwareComponentContainer components;
    private final InstanceGenerator instanceGenerator;
    private final Map<ConfigurationInternal, Set<TaskProvider<?>>> configurationToCompileTasks;
    private ProjectInternal project;

    @Inject
    public DefaultJvmPluginServices(ConfigurationContainer configurations, ObjectFactory objectFactory, ProviderFactory providerFactory, TaskContainer tasks, SoftwareComponentContainer components, InstanceGenerator instanceGenerator) {
        this.configurations = configurations;
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        this.tasks = tasks;
        this.components = components;
        this.instanceGenerator = instanceGenerator;
        this.configurationToCompileTasks = new HashMap(5);
    }

    @Override
    public void inject(ProjectInternal project) {
        this.project = project;
    }

    @Override
    public void configureAsCompileClasspath(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().apiUsage().withExternalDependencies().preferStandardJVM()));
    }

    @Override
    public void configureAsRuntimeClasspath(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().runtimeUsage().asJar().withExternalDependencies().preferStandardJVM()));
    }

    @Override
    public void configureAsApiElements(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().apiUsage().asJar().withExternalDependencies()));
    }

    @Override
    public void configureAsRuntimeElements(HasConfigurableAttributes<?> configuration) {
        this.configureAttributes(configuration, (Action<? super JvmEcosystemAttributesDetails>)((Action)details -> details.library().runtimeUsage().asJar().withExternalDependencies()));
    }

    @Override
    public <T> void configureAttributes(HasConfigurableAttributes<T> configurable, Action<? super JvmEcosystemAttributesDetails> configuration) {
        AttributeContainerInternal attributes = (AttributeContainerInternal)configurable.getAttributes();
        DefaultJvmEcosystemAttributesDetails details = (DefaultJvmEcosystemAttributesDetails)this.instanceGenerator.newInstance(DefaultJvmEcosystemAttributesDetails.class, new Object[]{this.objectFactory, attributes});
        configuration.execute((Object)details);
    }

    @Override
    public <COMPILE extends AbstractCompile> void useDefaultTargetPlatformInference(Configuration configuration, TaskProvider<COMPILE> compileTask) {
        ConfigurationInternal configurationInternal = (ConfigurationInternal)configuration;
        Set compileTasks = this.configurationToCompileTasks.computeIfAbsent(configurationInternal, key -> {
            HashSet taskProviders = new HashSet();
            configurationInternal.beforeLocking(this.configureDefaultTargetPlatform(configuration.isCanBeConsumed(), taskProviders));
            return taskProviders;
        });
        compileTasks.add(compileTask);
    }

    @Override
    public void replaceArtifacts(Configuration outgoingConfiguration, Object ... providers) {
        this.clearArtifacts(outgoingConfiguration);
        ConfigurationPublications outgoing = outgoingConfiguration.getOutgoing();
        for (Object provider : providers) {
            outgoing.artifact(provider);
        }
    }

    @Override
    public void registerJvmLanguageSourceDirectory(SourceSet sourceSet, String name, Action<? super JvmLanguageSourceDirectoryBuilder> configuration) {
        DefaultJvmLanguageSourceDirectoryBuilder builder = (DefaultJvmLanguageSourceDirectoryBuilder)this.instanceGenerator.newInstance(DefaultJvmLanguageSourceDirectoryBuilder.class, new Object[]{name, this.project, sourceSet});
        configuration.execute((Object)builder);
        builder.build();
    }

    @Override
    public void registerJvmLanguageGeneratedSourceDirectory(SourceSet sourceSet, Action<? super JvmLanguageGeneratedSourceDirectoryBuilder> configuration) {
        DefaultJvmLanguageGeneratedSourceDirectoryBuilder builder = (DefaultJvmLanguageGeneratedSourceDirectoryBuilder)this.instanceGenerator.newInstance(DefaultJvmLanguageGeneratedSourceDirectoryBuilder.class, new Object[]{this.project, sourceSet});
        configuration.execute((Object)builder);
        builder.build();
    }

    @Override
    public Provider<Configuration> registerDependencyBucket(String name, String description) {
        return this.project.getConfigurations().register(name, cnf -> {
            cnf.setCanBeResolved(false);
            cnf.setCanBeConsumed(false);
            cnf.setDescription(description);
        });
    }

    private void clearArtifacts(Configuration outgoingConfiguration) {
        outgoingConfiguration.getOutgoing().getArtifacts().clear();
        for (Configuration configuration : outgoingConfiguration.getExtendsFrom()) {
            this.clearArtifacts(configuration);
        }
    }

    @Override
    public ConfigurationVariant configureResourcesDirectoryVariant(Configuration configuration, SourceSet sourceSet) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("resources");
        variant.setDescription("Directories containing assembled resource files for " + sourceSet.getName() + ".");
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "resources")));
        DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
        DefaultSourceSetOutput.DirectoryContribution resourcesContribution = output.getResourcesContribution();
        if (resourcesContribution != null) {
            variant.artifact((Object)new LazyJavaDirectoryArtifact(this.project.getTaskDependencyFactory(), "java-resources-directory", resourcesContribution.getTask(), (Provider<File>)resourcesContribution.getDirectory()));
        }
        return variant;
    }

    @Override
    public ConfigurationVariant configureClassesDirectoryVariant(Configuration configuration, SourceSet sourceSet) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("classes");
        variant.setDescription("Directories containing compiled class files for " + sourceSet.getName() + ".");
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "classes")));
        variant.artifactsProvider(() -> {
            FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
            return classesDirs.getFiles().stream().map(file -> new LazyJavaDirectoryArtifact(this.project.getTaskDependencyFactory(), "java-classes-directory", classesDirs, (Provider<File>)this.providerFactory.provider(() -> file))).collect(Collectors.toList());
        });
        return variant;
    }

    private <COMPILE extends AbstractCompile> Action<ConfigurationInternal> configureDefaultTargetPlatform(boolean alwaysEnabled, Set<TaskProvider<COMPILE>> compileTasks) {
        return conf -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.project.getExtensions().findByType(JavaPluginExtension.class);
            if (alwaysEnabled || javaPluginExtension == null || !javaPluginExtension.getAutoTargetJvmDisabled()) {
                int majorVersion = 0;
                for (TaskProvider compileTaskProvider : compileTasks) {
                    AbstractCompile compileTask = (AbstractCompile)compileTaskProvider.get();
                    if (((HasCompileOptions)compileTask).getOptions().getRelease().isPresent()) {
                        majorVersion = Math.max(majorVersion, (Integer)((HasCompileOptions)compileTask).getOptions().getRelease().get());
                        continue;
                    }
                    int releaseFlag = DefaultJvmPluginServices.getReleaseOption(((HasCompileOptions)compileTask).getOptions().getCompilerArgs());
                    if (releaseFlag != 0) {
                        majorVersion = Math.max(majorVersion, releaseFlag);
                        continue;
                    }
                    majorVersion = Math.max(majorVersion, Integer.parseInt(JavaVersion.toVersion((Object)compileTask.getTargetCompatibility()).getMajorVersion()));
                }
                if (majorVersion != 0) {
                    JavaEcosystemSupport.configureDefaultTargetPlatform((HasAttributes)conf, (int)majorVersion);
                }
            }
        };
    }

    @Override
    public void createJvmVariant(String name, SourceSet sourceSet, Action<? super JvmVariantBuilder> action) {
        DefaultJvmVariantBuilder builder = (DefaultJvmVariantBuilder)this.instanceGenerator.newInstance(DefaultJvmVariantBuilder.class, new Object[]{name, sourceSet, new ProjectDerivedCapability((Project)this.project, name), this, this.configurations, this.tasks, this.components, this.project});
        action.execute((Object)builder);
        builder.build();
    }

    private static int getReleaseOption(List<String> compilerArgs) {
        int flagIndex = compilerArgs.indexOf("--release");
        if (flagIndex != -1 && flagIndex + 1 < compilerArgs.size()) {
            return Integer.parseInt(String.valueOf(compilerArgs.get(flagIndex + 1)));
        }
        return 0;
    }

    private static class LazyJavaDirectoryArtifact
    extends AbstractPublishArtifact {
        private final String type;
        private final Provider<File> fileProvider;

        public LazyJavaDirectoryArtifact(TaskDependencyFactory taskDependencyFactory, String type, Object dependency, Provider<File> fileProvider) {
            super(taskDependencyFactory, new Object[]{dependency});
            this.type = type;
            this.fileProvider = fileProvider;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getExtension() {
            return "";
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }

        public boolean shouldBePublished() {
            return false;
        }

        public File getFile() {
            return (File)this.fileProvider.get();
        }
    }
}

