/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.file.ReproducibleFileVisitor;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalker;
import org.gradle.api.internal.file.collections.DirectoryTrees;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.internal.file.collections.ReproducibleDirectoryWalker;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.file.Stat;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryFileTree
implements MinimalFileTree,
PatternFilterableFileTree,
RandomAccessFileCollection,
LocalFileTree,
DirectoryTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryFileTree.class);
    private static final DirectoryWalker DEFAULT_DIRECTORY_WALKER = new DefaultDirectoryWalker(FileSystems.getDefault());
    private static final DirectoryWalker REPRODUCIBLE_DIRECTORY_WALKER = new ReproducibleDirectoryWalker(FileSystems.getDefault());
    private final File dir;
    private final PatternSet patternSet;
    private final boolean postfix;
    private final FileSystem fileSystem;

    public DirectoryFileTree(File dir, PatternSet patternSet, FileSystem fileSystem) {
        this(dir, patternSet, fileSystem, false);
    }

    @VisibleForTesting
    public DirectoryFileTree(File dir, PatternSet patternSet, FileSystem fileSystem, boolean postfix) {
        this.patternSet = patternSet;
        this.dir = dir;
        this.fileSystem = fileSystem;
        this.postfix = postfix;
    }

    @Override
    public String getDisplayName() {
        String includes = this.patternSet.getIncludes().isEmpty() ? "" : String.format(" include %s", GUtil.toString((Iterable)this.patternSet.getIncludes()));
        String excludes = this.patternSet.getExcludes().isEmpty() ? "" : String.format(" exclude %s", GUtil.toString((Iterable)this.patternSet.getExcludes()));
        return String.format("directory '%s'%s%s", this.dir, includes, excludes);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public PatternSet getPatterns() {
        return this.patternSet;
    }

    public File getDir() {
        return this.dir;
    }

    @Override
    public DirectoryFileTree filter(PatternFilterable patterns) {
        PatternSet patternSet = this.patternSet.intersect();
        patternSet.copyFrom(patterns);
        return new DirectoryFileTree(this.dir, patternSet, this.fileSystem, this.postfix);
    }

    @Override
    public boolean contains(File file) {
        return DirectoryTrees.contains(this.fileSystem, this, file) && file.isFile();
    }

    @Override
    public void visitStructure(MinimalFileTree.MinimalFileTreeStructureVisitor visitor, FileTreeInternal owner) {
        visitor.visitFileTree(this.dir, this.patternSet, owner);
    }

    @Override
    public void visit(FileVisitor visitor) {
        this.visitFrom(visitor, this.dir, RelativePath.EMPTY_ROOT);
    }

    public void visitFrom(FileVisitor visitor, File fileOrDirectory, RelativePath path) {
        AtomicBoolean stopFlag = new AtomicBoolean();
        Spec spec = this.patternSet.getAsSpec();
        if (fileOrDirectory.exists()) {
            if (fileOrDirectory.isFile()) {
                this.processSingleFile(fileOrDirectory, visitor, (Spec<FileTreeElement>)spec, stopFlag);
            } else {
                this.walkDir(fileOrDirectory, path, visitor, (Spec<FileTreeElement>)spec, stopFlag);
            }
        } else {
            LOGGER.info("file or directory '{}', not found", (Object)fileOrDirectory);
        }
    }

    private void processSingleFile(File file, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag) {
        RelativePath path = new RelativePath(true, new String[]{file.getName()});
        DefaultFileVisitDetails details = new DefaultFileVisitDetails(file, path, stopFlag, (Chmod)this.fileSystem, (Stat)this.fileSystem);
        if (DirectoryFileTree.isAllowed(details, spec)) {
            visitor.visitFile((FileVisitDetails)details);
        }
    }

    private void walkDir(File file, RelativePath path, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag) {
        DirectoryWalker directoryWalker = visitor instanceof ReproducibleFileVisitor && ((ReproducibleFileVisitor)visitor).isReproducibleFileOrder() ? REPRODUCIBLE_DIRECTORY_WALKER : DEFAULT_DIRECTORY_WALKER;
        directoryWalker.walkDir(file, path, visitor, spec, stopFlag, this.postfix);
    }

    static boolean isAllowed(FileTreeElement element, Spec<? super FileTreeElement> spec) {
        return spec.isSatisfiedBy((Object)element);
    }

    public DirectoryFileTree postfix() {
        if (this.postfix) {
            return this;
        }
        return new DirectoryFileTree(this.dir, this.patternSet, this.fileSystem, true);
    }

    public PatternSet getPatternSet() {
        return this.patternSet;
    }
}

