/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.file.excludes.FileSystemDefaultExcludesListener;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.snapshot.impl.FileSystemSnapshotFilter;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileSystemAccess
implements FileSystemAccess,
FileSystemDefaultExcludesListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileSystemAccess.class);
    private final VirtualFileSystem virtualFileSystem;
    private final Stat stat;
    private final Interner<String> stringInterner;
    private final FileSystemAccess.WriteListener writeListener;
    private final DirectorySnapshotterStatistics.Collector statisticsCollector;
    private ImmutableList<String> defaultExcludes;
    private DirectorySnapshotter directorySnapshotter;
    private final FileHasher hasher;
    private final StripedProducerGuard<String> producingSnapshots = new StripedProducerGuard();

    public DefaultFileSystemAccess(FileHasher hasher, Interner<String> stringInterner, Stat stat, VirtualFileSystem virtualFileSystem, FileSystemAccess.WriteListener writeListener, DirectorySnapshotterStatistics.Collector statisticsCollector, String ... defaultExcludes) {
        this.stringInterner = stringInterner;
        this.stat = stat;
        this.writeListener = writeListener;
        this.statisticsCollector = statisticsCollector;
        this.defaultExcludes = ImmutableList.copyOf((Object[])defaultExcludes);
        this.directorySnapshotter = new DirectorySnapshotter(hasher, stringInterner, (Collection<String>)this.defaultExcludes, statisticsCollector);
        this.hasher = hasher;
        this.virtualFileSystem = virtualFileSystem;
    }

    @Override
    public FileSystemLocationSnapshot read(String location) {
        return this.readLocation(location);
    }

    @Override
    public Optional<HashCode> readRegularFileContentHash(String location) {
        return this.virtualFileSystem.findMetadata(location).flatMap(snapshot -> {
            if (snapshot.getType() != FileType.RegularFile) {
                return Optional.of(Optional.empty());
            }
            if (snapshot instanceof FileSystemLocationSnapshot) {
                return Optional.of(Optional.of((FileSystemLocationSnapshot)snapshot));
            }
            return Optional.empty();
        }).orElseGet(() -> this.virtualFileSystem.store(location, vfsStorer -> {
            File file = new File(location);
            FileMetadata fileMetadata = this.stat.stat(file);
            switch (fileMetadata.getType()) {
                case Missing: {
                    vfsStorer.store(new MissingFileSnapshot(location, fileMetadata.getAccessType()));
                    return Optional.empty();
                }
                case Directory: {
                    return Optional.empty();
                }
                case RegularFile: {
                    return Optional.of(this.producingSnapshots.guardByKey(location, () -> this.virtualFileSystem.findSnapshot(location).orElseGet(() -> {
                        HashCode hashCode = this.hasher.hash(file, fileMetadata.getLength(), fileMetadata.getLastModified());
                        return vfsStorer.store(new RegularFileSnapshot(location, file.getName(), hashCode, fileMetadata));
                    })));
                }
            }
            throw new IllegalArgumentException("Unknown file type: " + fileMetadata.getType());
        })).map(FileSystemLocationSnapshot::getHash);
    }

    @Override
    public Optional<FileSystemLocationSnapshot> read(String location, SnapshottingFilter filter) {
        if (filter.isEmpty()) {
            return Optional.of(this.read(location));
        }
        FileSystemSnapshot filteredSnapshot = this.readSnapshotFromLocation(location, snapshot -> FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot), () -> {
            FileSystemLocationSnapshot snapshot = this.snapshot(location, filter);
            return snapshot.getType() == FileType.Directory ? snapshot : FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot);
        });
        if (filteredSnapshot instanceof FileSystemLocationSnapshot) {
            return Optional.of((FileSystemLocationSnapshot)filteredSnapshot);
        }
        return Optional.empty();
    }

    private FileSystemLocationSnapshot snapshot(String location, SnapshottingFilter filter) {
        return this.virtualFileSystem.store(location, vfsStorer -> {
            File file = new File(location);
            FileMetadata fileMetadata = this.stat.stat(file);
            switch (fileMetadata.getType()) {
                case RegularFile: {
                    HashCode hash = this.hasher.hash(file, fileMetadata.getLength(), fileMetadata.getLastModified());
                    return vfsStorer.store(new RegularFileSnapshot(location, file.getName(), hash, fileMetadata));
                }
                case Missing: {
                    return vfsStorer.store(new MissingFileSnapshot(location, fileMetadata.getAccessType()));
                }
                case Directory: {
                    return this.directorySnapshotter.snapshot(location, filter.isEmpty() ? null : filter.getAsDirectoryWalkerPredicate(), vfsStorer::store);
                }
            }
            throw new UnsupportedOperationException();
        });
    }

    private FileSystemLocationSnapshot readLocation(String location) {
        return this.readSnapshotFromLocation(location, () -> this.snapshot(location, SnapshottingFilter.EMPTY));
    }

    private FileSystemLocationSnapshot readSnapshotFromLocation(String location, Supplier<FileSystemLocationSnapshot> readFromDisk) {
        return this.readSnapshotFromLocation(location, Function.identity(), readFromDisk);
    }

    private <T> T readSnapshotFromLocation(String location, Function<FileSystemLocationSnapshot, T> snapshotProcessor, Supplier<T> readFromDisk) {
        return (T)this.virtualFileSystem.findSnapshot(location).map(snapshotProcessor).orElseGet(() -> this.producingSnapshots.guardByKey(location, () -> this.lambda$readSnapshotFromLocation$9(location, snapshotProcessor, (Supplier)readFromDisk)));
    }

    @Override
    public void write(Iterable<String> locations, Runnable action) {
        this.writeListener.locationsWritten(locations);
        this.virtualFileSystem.invalidate(locations);
        action.run();
    }

    @Override
    public void record(FileSystemLocationSnapshot snapshot) {
        this.virtualFileSystem.store(snapshot.getAbsolutePath(), () -> snapshot);
    }

    public void onDefaultExcludesChanged(List<String> excludes) {
        ImmutableList newDefaultExcludes = ImmutableList.copyOf(excludes);
        if (!this.defaultExcludes.equals((Object)newDefaultExcludes)) {
            LOGGER.debug("Default excludes changes from {} to {}", this.defaultExcludes, (Object)newDefaultExcludes);
            this.defaultExcludes = newDefaultExcludes;
            this.directorySnapshotter = new DirectorySnapshotter(this.hasher, this.stringInterner, (Collection<String>)newDefaultExcludes, this.statisticsCollector);
            this.virtualFileSystem.invalidateAll();
        }
    }

    private /* synthetic */ Object lambda$readSnapshotFromLocation$9(String location, Function snapshotProcessor, Supplier readFromDisk) {
        return this.virtualFileSystem.findSnapshot(location).map(snapshotProcessor).orElseGet(readFromDisk);
    }

    private static class StripedProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                V v = supplier.get();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

