/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.language.LibraryDependencies;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppStaticLibrary;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultLibraryDependencies;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppLibrary
extends DefaultCppComponent
implements CppLibrary,
PublicationAwareComponent {
    private final ObjectFactory objectFactory;
    private final ConfigurableFileCollection publicHeaders;
    private final FileCollection publicHeadersWithConvention;
    private final SetProperty<Linkage> linkage;
    private final Property<CppBinary> developmentBinary;
    private final Configuration apiElements;
    private final MainLibraryVariant mainVariant;
    private final DefaultLibraryDependencies dependencies;

    @Inject
    public DefaultCppLibrary(String name, ObjectFactory objectFactory, RoleBasedConfigurationContainerInternal configurations, ImmutableAttributesFactory immutableAttributesFactory) {
        super(name, objectFactory);
        this.objectFactory = objectFactory;
        this.developmentBinary = objectFactory.property(CppBinary.class);
        this.publicHeaders = objectFactory.fileCollection();
        this.publicHeadersWithConvention = this.createDirView(this.publicHeaders, "src/" + name + "/public");
        this.linkage = objectFactory.setProperty(Linkage.class);
        this.linkage.set(Collections.singleton(Linkage.SHARED));
        this.dependencies = (DefaultLibraryDependencies)objectFactory.newInstance(DefaultLibraryDependencies.class, new Object[]{this.getNames().withSuffix("implementation"), this.getNames().withSuffix("api")});
        Usage apiUsage = (Usage)objectFactory.named(Usage.class, "cplusplus-api");
        this.apiElements = configurations.createWithRole(this.getNames().withSuffix("cppApiElements"), (ConfigurationRole)ConfigurationRolesForMigration.INTENDED_CONSUMABLE_BUCKET_TO_INTENDED_CONSUMABLE);
        this.apiElements.extendsFrom(new Configuration[]{this.dependencies.getApiDependencies()});
        this.apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
        this.apiElements.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        AttributeContainerInternal publicationAttributes = immutableAttributesFactory.mutable();
        publicationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
        publicationAttributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip");
        this.mainVariant = new MainLibraryVariant("api", this.apiElements, (AttributeContainer)publicationAttributes, objectFactory);
    }

    public DefaultCppSharedLibrary addSharedLibrary(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppSharedLibrary result = (DefaultCppSharedLibrary)this.objectFactory.newInstance(DefaultCppSharedLibrary.class, new Object[]{this.getNames().append(identity.getName()), this.getBaseName(), this.getCppSource(), this.getAllHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    public DefaultCppStaticLibrary addStaticLibrary(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppStaticLibrary result = (DefaultCppStaticLibrary)this.objectFactory.newInstance(DefaultCppStaticLibrary.class, new Object[]{this.getNames().append(identity.getName()), this.getBaseName(), this.getCppSource(), this.getAllHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"C++ library", (String)this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public Configuration getApiDependencies() {
        return this.dependencies.getApiDependencies();
    }

    @Override
    public LibraryDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super LibraryDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public Configuration getApiElements() {
        return this.apiElements;
    }

    @Override
    public MainLibraryVariant getMainPublication() {
        return this.mainVariant;
    }

    @Override
    public ConfigurableFileCollection getPublicHeaders() {
        return this.publicHeaders;
    }

    @Override
    public void publicHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.publicHeaders);
    }

    @Override
    public FileCollection getPublicHeaderDirs() {
        return this.publicHeadersWithConvention;
    }

    @Override
    public FileTree getPublicHeaderFiles() {
        PatternSet patterns = new PatternSet();
        patterns.include(new String[]{"**/*.h"});
        patterns.include(new String[]{"**/*.hpp"});
        return this.publicHeadersWithConvention.getAsFileTree().matching((PatternFilterable)patterns);
    }

    @Override
    public FileCollection getAllHeaderDirs() {
        return this.publicHeadersWithConvention.plus(super.getAllHeaderDirs());
    }

    public Property<CppBinary> getDevelopmentBinary() {
        return this.developmentBinary;
    }

    @Override
    public SetProperty<Linkage> getLinkage() {
        return this.linkage;
    }
}

