/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.EndCollection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.BoundTransformationStep;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformingAsyncArtifactListener;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public abstract class AbstractTransformedArtifactSet
implements TransformedArtifactSet,
FileCollectionInternal.Source {
    private final CalculatedValueContainer<ImmutableList<ResolvedArtifactSet.Artifacts>, CalculateArtifacts> result;

    public AbstractTransformedArtifactSet(ComponentIdentifier componentIdentifier, ResolvedArtifactSet delegate, ImmutableAttributes targetVariantAttributes, List<? extends Capability> capabilities, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        TransformUpstreamDependenciesResolver dependenciesResolver = dependenciesResolverFactory.create(componentIdentifier, transformation);
        ImmutableList.Builder builder = ImmutableList.builder();
        transformation.visitTransformationSteps((Action<? super TransformationStep>)((Action)transformationStep -> builder.add((Object)new BoundTransformationStep((TransformationStep)transformationStep, dependenciesResolver.dependenciesFor((TransformationStep)transformationStep)))));
        ImmutableList steps = builder.build();
        this.result = calculatedValueContainerFactory.create(Describables.of((Object)componentIdentifier), (ValueCalculator)new CalculateArtifacts(componentIdentifier, delegate, targetVariantAttributes, capabilities, (ImmutableList<BoundTransformationStep>)steps));
    }

    public AbstractTransformedArtifactSet(CalculatedValueContainer<ImmutableList<ResolvedArtifactSet.Artifacts>, CalculateArtifacts> result) {
        this.result = result;
    }

    public CalculatedValueContainer<ImmutableList<ResolvedArtifactSet.Artifacts>, CalculateArtifacts> getResult() {
        return this.result;
    }

    @Override
    public void visit(ResolvedArtifactSet.Visitor visitor) {
        FileCollectionStructureVisitor.VisitType visitType = visitor.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            visitor.visitArtifacts(new EndCollection(this));
            return;
        }
        this.result.finalizeIfNotAlready();
        for (ResolvedArtifactSet.Artifacts artifacts : (ImmutableList)this.result.get()) {
            artifacts.prepareForVisitingIfNotAlready();
            visitor.visitArtifacts(artifacts);
        }
        visitor.visitArtifacts(new EndCollection(this));
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.result.visitDependencies(context);
    }

    @Override
    public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
        throw new IllegalStateException();
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        throw new IllegalStateException();
    }

    public static class CalculateArtifacts
    implements ValueCalculator<ImmutableList<ResolvedArtifactSet.Artifacts>> {
        private final ComponentIdentifier ownerId;
        private final ResolvedArtifactSet delegate;
        private final ImmutableList<BoundTransformationStep> steps;
        private final ImmutableAttributes targetVariantAttributes;
        private final List<? extends Capability> capabilities;

        public CalculateArtifacts(ComponentIdentifier ownerId, ResolvedArtifactSet delegate, ImmutableAttributes targetVariantAttributes, List<? extends Capability> capabilities, ImmutableList<BoundTransformationStep> steps) {
            this.ownerId = ownerId;
            this.delegate = delegate;
            this.steps = steps;
            this.targetVariantAttributes = targetVariantAttributes;
            this.capabilities = capabilities;
        }

        public ComponentIdentifier getOwnerId() {
            return this.ownerId;
        }

        public ResolvedArtifactSet getDelegate() {
            return this.delegate;
        }

        public ImmutableList<BoundTransformationStep> getSteps() {
            return this.steps;
        }

        public ImmutableAttributes getTargetVariantAttributes() {
            return this.targetVariantAttributes;
        }

        public List<? extends Capability> getCapabilities() {
            return this.capabilities;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            for (BoundTransformationStep step : this.steps) {
                context.add((Object)step.getUpstreamDependencies());
            }
        }

        public ImmutableList<ResolvedArtifactSet.Artifacts> calculateValue(NodeExecutionContext context) {
            for (BoundTransformationStep step : this.steps) {
                step.getTransformation().isolateParametersIfNotAlready();
                step.getUpstreamDependencies().finalizeIfNotAlready();
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)1);
            this.delegate.visit(new TransformingAsyncArtifactListener((List<BoundTransformationStep>)this.steps, this.targetVariantAttributes, this.capabilities, (ImmutableList.Builder<ResolvedArtifactSet.Artifacts>)builder));
            return builder.build();
        }
    }
}

