/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.DefaultLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultLocalComponentMetadata
implements LocalComponentMetadata,
BuildableLocalComponentMetadata {
    private final Map<String, DefaultLocalConfigurationMetadata> allConfigurations = Maps.newLinkedHashMap();
    private final ComponentIdentifier componentId;
    private final ModuleVersionIdentifier moduleVersionId;
    private final String status;
    private final AttributesSchemaInternal attributesSchema;
    private final ModelContainer<?> model;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ModuleSources moduleSources = ImmutableModuleSources.of();
    private Optional<List<? extends VariantGraphResolveMetadata>> consumableConfigurations;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier moduleVersionId, ComponentIdentifier componentId, String status, AttributesSchemaInternal attributesSchema, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.moduleVersionId = moduleVersionId;
        this.componentId = componentId;
        this.status = status;
        this.attributesSchema = attributesSchema;
        this.model = model;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionId;
    }

    @Override
    public DefaultLocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        DefaultLocalComponentMetadata copy = new DefaultLocalComponentMetadata(this.moduleVersionId, componentIdentifier, this.status, this.attributesSchema, this.model, this.calculatedValueContainerFactory);
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            copy.addConfiguration(configuration.getName(), configuration.getDescription(), configuration.getExtendsFrom(), configuration.getHierarchy(), configuration.isVisible(), configuration.isTransitive(), configuration.getAttributes(), configuration.isCanBeConsumed(), configuration.getConsumptionDeprecation(), configuration.isCanBeResolved(), configuration.getCapabilities());
        }
        HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts = new HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>();
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            configuration.realizeDependencies();
            configuration.prepareToResolveArtifacts();
            DefaultLocalConfigurationMetadata configurationCopy = copy.allConfigurations.get(configuration.getName());
            configurationCopy.definedDependencies.addAll(configuration.definedDependencies);
            configurationCopy.definedFiles.addAll(configuration.definedFiles);
            configurationCopy.definedExcludes.addAll(configuration.definedExcludes);
            ImmutableList<LocalComponentArtifactMetadata> newArtifacts = this.copyArtifacts((List<LocalComponentArtifactMetadata>)configuration.getArtifacts(), artifacts, (Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>)transformedArtifacts);
            configurationCopy.artifacts = this.calculatedValueContainerFactory.create(Describables.of((Object)configurationCopy.getDescription(), (Object)"artifacts"), newArtifacts);
            configurationCopy.sourceArtifacts = null;
            for (LocalVariantMetadata oldVariant : configuration.getVariants()) {
                oldVariant.prepareToResolveArtifacts();
                ImmutableList<LocalComponentArtifactMetadata> newVariantArtifacts = this.copyArtifacts((List<LocalComponentArtifactMetadata>)oldVariant.getArtifacts(), artifacts, (Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>)transformedArtifacts);
                configurationCopy.variants.add(new LocalVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), newVariantArtifacts, (ImmutableCapabilities)oldVariant.getCapabilities(), this.calculatedValueContainerFactory));
            }
        }
        return copy;
    }

    private ImmutableList<LocalComponentArtifactMetadata> copyArtifacts(List<LocalComponentArtifactMetadata> artifacts, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        if (artifacts.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder newArtifacts = new ImmutableList.Builder();
        for (LocalComponentArtifactMetadata oldArtifact : artifacts) {
            newArtifacts.add((Object)this.copyArtifact(oldArtifact, transformer, transformedArtifacts));
        }
        return newArtifacts.build();
    }

    private LocalComponentArtifactMetadata copyArtifact(LocalComponentArtifactMetadata oldArtifact, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        LocalComponentArtifactMetadata newArtifact = transformedArtifacts.get(oldArtifact);
        if (newArtifact == null) {
            newArtifact = (LocalComponentArtifactMetadata)transformer.transform((Object)oldArtifact);
            transformedArtifacts.put(oldArtifact, newArtifact);
        }
        return newArtifact;
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, ImmutableSet<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities) {
        assert (hierarchy.contains((Object)name));
        DefaultLocalConfigurationMetadata conf = new DefaultLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities, this.model, this.calculatedValueContainerFactory, this);
        this.allConfigurations.put(name, conf);
        return conf;
    }

    @Override
    public void addDependenciesAndExcludesForConfiguration(ConfigurationInternal configuration, LocalConfigurationMetadataBuilder localConfigurationMetadataBuilder) {
        DefaultLocalConfigurationMetadata configurationMetadata = this.allConfigurations.get(configuration.getName());
        configurationMetadata.configurationMetadataBuilder = localConfigurationMetadataBuilder;
        configurationMetadata.backingConfiguration = configuration;
    }

    public String toString() {
        return this.componentId.getDisplayName();
    }

    @Override
    public ModuleSources getSources() {
        return this.moduleSources;
    }

    @Override
    public ComponentResolveMetadata withSources(ModuleSources source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public synchronized Optional<List<? extends VariantGraphResolveMetadata>> getVariantsForGraphTraversal() {
        if (this.consumableConfigurations == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean hasAtLeastOneConsumableConfiguration = false;
            for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
                if (!configuration.isCanBeConsumed() || configuration.getAttributes().isEmpty()) continue;
                hasAtLeastOneConsumableConfiguration = true;
                builder.add((Object)configuration);
            }
            this.consumableConfigurations = hasAtLeastOneConsumableConfiguration ? Optional.of((Object)builder.build()) : Optional.absent();
        }
        return this.consumableConfigurations;
    }

    @Override
    public DefaultLocalConfigurationMetadata getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    @Override
    public void reevaluate() {
        for (DefaultLocalConfigurationMetadata conf : this.allConfigurations.values()) {
            conf.reevaluate();
        }
    }
}

